/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.text;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import com.hendraanggrian.text.SpanGetter;
import com.hendraanggrian.text.Spannable2;
import com.hendraanggrian.text.Spannables;
import com.hendraanggrian.text.SpannedArg;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public final class SpannableText
extends SpannableString
implements Spannable2 {
    public SpannableText(@NonNull CharSequence text) {
        super(text);
    }

    public SpannableText(@NonNull CharSequence text, Object ... spans) {
        this(text, 33, spans);
    }

    public SpannableText(@NonNull CharSequence text, int flags, Object ... spans) {
        super(text);
        Spannables.setSpans((Spannable)this, flags, spans);
    }

    @Override
    public void setSpans(int start, int end, int flags, Object ... spans) {
        Spannables.setSpans((Spannable)this, start, end, flags, spans);
    }

    @Override
    public void setSpans(int start, int end, Object ... spans) {
        Spannables.setSpans((Spannable)this, start, end, spans);
    }

    @Override
    public void setSpans(int flags, Object ... spans) {
        Spannables.setSpans((Spannable)this, flags, spans);
    }

    @Override
    public void setSpans(Object ... spans) {
        Spannables.setSpans((Spannable)this, spans);
    }

    @Override
    public void removeSpans(Object ... spans) {
        Spannables.removeSpans(this, spans);
    }

    @Override
    @NonNull
    public Collection<Object> putSpans(@NonNull CharSequence text, int flags, SpanGetter ... getters) {
        return Spannables.putSpans((Spannable)this, text, flags, getters);
    }

    @Override
    @NonNull
    public Collection<Object> putSpans(@NonNull CharSequence text, SpanGetter ... getters) {
        return Spannables.putSpans((Spannable)this, text, getters);
    }

    @Override
    @NonNull
    public Collection<Object> putSpansAll(@NonNull Pattern regex, int flags, SpanGetter ... getters) {
        return Spannables.putSpansAll((Spannable)this, regex, flags, getters);
    }

    @Override
    @NonNull
    public Collection<Object> putSpansAll(@NonNull String regex, int flags, SpanGetter ... getters) {
        return Spannables.putSpansAll((Spannable)this, regex, flags, getters);
    }

    @Override
    @NonNull
    public Collection<Object> putSpansAll(@NonNull Pattern regex, SpanGetter ... getters) {
        return Spannables.putSpansAll((Spannable)this, regex, getters);
    }

    @Override
    @NonNull
    public Collection<Object> putSpansAll(@NonNull String regex, SpanGetter ... getters) {
        return Spannables.putSpansAll((Spannable)this, regex, getters);
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder((CharSequence)((Object)this));
    }

    @NonNull
    public static SpannableText format(@NonNull String format, Object ... args) {
        List<Integer> list = Spannables.listOccurrences(format, "%");
        for (int start : Spannables.listOccurrences(format, "%%")) {
            list.remove((Object)start);
            list.remove((Object)(start + 1));
        }
        if (list.size() != args.length) {
            throw new IllegalArgumentException("Expected argument " + list.size() + ", was " + args.length);
        }
        Builder builder = new Builder();
        String remaining = format;
        int lastIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            String subformat = format.substring(lastIndex, list.get(i) + 2);
            lastIndex = list.get(i) + 2;
            remaining = remaining.substring(subformat.length());
            builder.append(subformat.substring(0, subformat.length() - 2));
            Object arg = args[i];
            if (arg instanceof SpannedArg) {
                builder.append((CharSequence)String.format(subformat.substring(subformat.length() - 2), ((SpannedArg)arg).arg), ((SpannedArg)arg).flags, ((SpannedArg)arg).spans);
                continue;
            }
            builder.append(String.format(subformat.substring(subformat.length() - 2), arg));
        }
        builder.append(remaining);
        return builder.build();
    }

    @NonNull
    public static SpannableText valueOf(@NonNull CharSequence text) {
        return text instanceof SpannableText ? (SpannableText)((Object)text) : new SpannableText(text);
    }

    public static final class Builder
    extends SpannableStringBuilder
    implements Spannable2 {
        public Builder() {
            this("");
        }

        public Builder(@NonNull CharSequence text) {
            this(text, 0, text.length());
        }

        public Builder(@NonNull CharSequence text, int start, int end) {
            super(text, start, end);
        }

        @Override
        public void setSpans(int start, int end, int flags, Object ... spans) {
            Spannables.setSpans((Spannable)this, start, end, flags, spans);
        }

        @Override
        public void setSpans(int start, int end, Object ... spans) {
            Spannables.setSpans((Spannable)this, start, end, spans);
        }

        @Override
        public void setSpans(int flags, Object ... spans) {
            Spannables.setSpans((Spannable)this, flags, spans);
        }

        @Override
        public void setSpans(Object ... spans) {
            Spannables.setSpans((Spannable)this, spans);
        }

        @Override
        public void removeSpans(Object ... spans) {
            Spannables.removeSpans(this, spans);
        }

        @Override
        @NonNull
        public Collection<Object> putSpans(@NonNull CharSequence text, int flags, SpanGetter ... getters) {
            return Spannables.putSpans((Spannable)this, text, flags, getters);
        }

        @Override
        @NonNull
        public Collection<Object> putSpans(@NonNull CharSequence text, SpanGetter ... getters) {
            return Spannables.putSpans((Spannable)this, text, getters);
        }

        @Override
        @NonNull
        public Collection<Object> putSpansAll(@NonNull Pattern regex, int flags, SpanGetter ... getters) {
            return Spannables.putSpansAll((Spannable)this, regex, flags, getters);
        }

        @Override
        @NonNull
        public Collection<Object> putSpansAll(@NonNull String regex, int flags, SpanGetter ... getters) {
            return Spannables.putSpansAll((Spannable)this, regex, flags, getters);
        }

        @Override
        @NonNull
        public Collection<Object> putSpansAll(@NonNull Pattern regex, SpanGetter ... getters) {
            return Spannables.putSpansAll((Spannable)this, regex, getters);
        }

        @Override
        @NonNull
        public Collection<Object> putSpansAll(@NonNull String regex, SpanGetter ... getters) {
            return Spannables.putSpansAll((Spannable)this, regex, getters);
        }

        @NonNull
        public Builder append(char text) {
            super.append(text);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text) {
            super.append(text);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, int start, int end) {
            super.append(text, start, end);
            return this;
        }

        @RequiresApi(value=21)
        @NonNull
        public Builder append(@NonNull CharSequence text, @NonNull Object what, int flags) {
            super.append(text, what, flags);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, Object ... spans) {
            return this.append(text, 33, spans);
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, int flags, Object ... spans) {
            super.append(text);
            int end = this.length();
            int start = end - text.length();
            for (Object what : spans) {
                this.setSpan(what, start, end, flags);
            }
            return this;
        }

        @NonNull
        public SpannableText build() {
            return new SpannableText((CharSequence)((Object)this));
        }

        @NonNull
        public static Builder valueOf(@NonNull CharSequence text) {
            return text instanceof Builder ? (Builder)((Object)text) : new Builder(text);
        }
    }
}

