package com.hendraanggrian.text.style;

import android.annotation.SuppressLint;
import android.content.res.AssetManager;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;

import java.io.File;

/**
 * @author Hendra Anggrian (hendraanggrian@gmail.com)
 */
@SuppressLint("ParcelCreator")
public class FontSpan extends TypefaceSpan {

    @NonNull private final Typeface typeface;

    public FontSpan(@NonNull String file) {
        this(Typeface.createFromFile(file));
    }

    public FontSpan(String family, @NonNull String file) {
        this(family, Typeface.createFromFile(file));
    }

    public FontSpan(@NonNull File file) {
        this(Typeface.createFromFile(file));
    }

    public FontSpan(String family, @NonNull File file) {
        this(family, Typeface.createFromFile(file));
    }

    public FontSpan(@NonNull AssetManager mgr, @NonNull String path) {
        this(Typeface.createFromAsset(mgr, path));
    }

    public FontSpan(String family, @NonNull AssetManager mgr, @NonNull String path) {
        this(family, Typeface.createFromAsset(mgr, path));
    }

    public FontSpan(@NonNull Typeface typeface) {
        this("", typeface);
    }

    public FontSpan(String family, @NonNull Typeface typeface) {
        super(family);
        this.typeface = typeface;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        applyCustomTypeface(textPaint);
    }

    @Override
    public void updateMeasureState(TextPaint paint) {
        applyCustomTypeface(paint);
    }

    private void applyCustomTypeface(Paint paint) {
        int oldStyle;
        Typeface old = paint.getTypeface();
        oldStyle = old == null
                ? 0
                : old.getStyle();
        int fake = oldStyle & ~typeface.getStyle();
        if ((fake & Typeface.BOLD) != 0)
            paint.setFakeBoldText(true);
        if ((fake & Typeface.ITALIC) != 0)
            paint.setTextSkewX(-0.25f);
        paint.setTypeface(typeface);
    }
}