package com.hendraanggrian.text;

import android.support.annotation.NonNull;
import android.text.Spannable;

/**
 * @author Hendra Anggrian (hendraanggrian@gmail.com)
 */
public final class SpannedArg {

    @NonNull final Object arg;
    @SpannableText.Flags final int flags;
    @NonNull final Object[] spans;

    public SpannedArg(@NonNull Object arg, @NonNull Object... spans) {
        this(arg, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE, spans);
    }

    public SpannedArg(@NonNull Object arg, @SpannableText.Flags int flags, @NonNull Object... spans) {
        this.arg = arg;
        this.flags = flags;
        this.spans = spans;
    }
}