package com.hendraanggrian.text;

import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.text.Spannable;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Extension of {@link Spannable} with multiple spans operation.
 * See {@link Spannables} for implementation.
 *
 * @author Hendra Anggrian (hendraanggrian@gmail.com)
 * @see SpannableText
 * @see SpannableText.Builder
 */
interface Spannable2 extends Spannable {

    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            SPAN_PARAGRAPH,
            SPAN_INCLUSIVE_EXCLUSIVE, // or SPAN_MARK_MARK
            SPAN_INCLUSIVE_INCLUSIVE, // or SPAN_MARK_POINT
            SPAN_EXCLUSIVE_EXCLUSIVE, // or SPAN_POINT_MARK
            SPAN_EXCLUSIVE_INCLUSIVE, // or SPAN_POINT_POINT
            SPAN_COMPOSING,
            SPAN_INTERMEDIATE,
            SPAN_USER,
            SPAN_PRIORITY
    })
    @interface Flags {
    }

    void setSpans(int start, int end, @Flags int flags, @NonNull Object... spans);

    void setSpans(int start, int end, @NonNull Object... spans);

    void setSpans(@Flags int flags, @NonNull Object... spans);

    void setSpans(@NonNull Object... spans);

    void removeSpans(@NonNull Object... spans);

    void putSpans(@NonNull CharSequence text, @Flags int flags, @NonNull SpanGetter... getters);

    void putSpans(@NonNull CharSequence text, @NonNull SpanGetter... getters);

    void putSpansAll(@NonNull String regex, @Flags int flags, @NonNull SpanGetter... getters);

    void putSpansAll(@NonNull String regex, @NonNull SpanGetter... getters);
}