/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.compat.view;

import android.app.Activity;
import android.content.Context;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class InputMethods {
    private InputMethods() {
    }

    public static boolean showSoftInput(@NonNull Activity activity) {
        return InputMethods.showSoftInput(activity, 1);
    }

    public static boolean showSoftInput(@NonNull Activity activity, int flags) {
        return InputMethods.showSoftInput(activity, flags, null);
    }

    public static boolean showSoftInput(@NonNull Activity activity, int flags, @Nullable ResultReceiver receiver) {
        View currentFocus = activity.getCurrentFocus();
        return currentFocus != null && InputMethods.showSoftInput(currentFocus, flags, receiver);
    }

    public static boolean showSoftInput(@NonNull View view) {
        return InputMethods.showSoftInput(view, 1);
    }

    public static boolean showSoftInput(@NonNull View view, int flags) {
        return InputMethods.showSoftInput(view, flags, null);
    }

    public static boolean showSoftInput(@NonNull View view, int flags, @Nullable ResultReceiver receiver) {
        return InputMethods.getInputMethodManager(view.getContext()).showSoftInput(view, flags, receiver);
    }

    public static boolean hideSoftInput(@NonNull Activity activity) {
        return InputMethods.hideSoftInput(activity, 2);
    }

    public static boolean hideSoftInput(@NonNull Activity activity, int flags) {
        return InputMethods.hideSoftInput(activity, flags, null);
    }

    public static boolean hideSoftInput(@NonNull Activity activity, int flags, @Nullable ResultReceiver receiver) {
        View currentFocus = activity.getCurrentFocus();
        return currentFocus != null && InputMethods.hideSoftInput(currentFocus, flags, receiver);
    }

    public static boolean hideSoftInput(@NonNull View view) {
        return InputMethods.hideSoftInput(view, 2);
    }

    public static boolean hideSoftInput(@NonNull View view, int flags) {
        return InputMethods.hideSoftInput(view, flags, null);
    }

    public static boolean hideSoftInput(@NonNull View view, int flags, @Nullable ResultReceiver receiver) {
        return InputMethods.getInputMethodManager(view.getContext()).hideSoftInputFromWindow(view.getWindowToken(), flags, receiver);
    }

    @NonNull
    private static InputMethodManager getInputMethodManager(@NonNull Context context) {
        return (InputMethodManager)context.getSystemService("input_method");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HideFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowFlags {
    }
}

