/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.commons.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;

public final class Themes {
    private Themes() {
    }

    @ColorInt
    public static int getColorFromAttrRes(@NonNull Context context, @AttrRes int attr, @ColorInt int defaultValue) {
        return Themes.getColorFromAttrRes(context.getTheme(), attr, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int getColorFromAttrRes(@NonNull Resources.Theme theme, @AttrRes int attr, @ColorInt int defaultValue) {
        TypedArray a = theme.obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getColor(0, defaultValue);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static float getFloatFromAttrRes(@NonNull Context context, @AttrRes int attr, float defaultValue) {
        return Themes.getFloatFromAttrRes(context.getTheme(), attr, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFloatFromAttrRes(@NonNull Resources.Theme theme, @AttrRes int attr, float defaultValue) {
        TypedArray a = theme.obtainStyledAttributes(new int[]{attr});
        try {
            float f = a.getFloat(0, defaultValue);
            return f;
        }
        finally {
            a.recycle();
        }
    }
}

