/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.commons.content;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import com.hendraanggrian.commons.content.Themes;

public final class Drawables {
    private Drawables() {
    }

    @NonNull
    public static Drawable fromBitmap(@NonNull Resources res, @NonNull Bitmap bitmap) {
        return new BitmapDrawable(res, bitmap);
    }

    @NonNull
    public static Drawable fromColor(@ColorInt int color) {
        return new ColorDrawable(color);
    }

    @NonNull
    public static Drawable fromColorRes(@NonNull Context context, @ColorRes int colorRes) {
        return Drawables.fromColor(ContextCompat.getColor((Context)context, (int)colorRes));
    }

    @NonNull
    public static Drawable fromColorAttr(@NonNull Context context, @AttrRes int colorAttr) {
        int color = Themes.getColor(context, colorAttr, -1);
        if (color != -1) {
            return Drawables.fromColor(color);
        }
        throw new IllegalArgumentException("invalid attribute!");
    }

    @NonNull
    public static Bitmap toBitmap(@NonNull Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
            return bitmap;
        }
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }
}

