/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;

class Hibernate5NaturalIdKeySerializer
implements StreamSerializer<Object> {
    private static final Class<?> CACHE_KEY_CLASS;
    private static final long ENTITY_NAME_OFFSET;
    private static final long HASH_CODE_OFFSET;
    private static final long NATURAL_ID_VALUES_OFFSET;
    private static final long TENANT_ID_OFFSET;

    Hibernate5NaturalIdKeySerializer() {
    }

    public void write(ObjectDataOutput out, Object object) throws IOException {
        try {
            Serializable[] naturalIdValues = (Serializable[])UnsafeHelper.UNSAFE.getObject(object, NATURAL_ID_VALUES_OFFSET);
            String entityName = (String)UnsafeHelper.UNSAFE.getObject(object, ENTITY_NAME_OFFSET);
            String tenantId = (String)UnsafeHelper.UNSAFE.getObject(object, TENANT_ID_OFFSET);
            int hashCode = UnsafeHelper.UNSAFE.getInt(object, HASH_CODE_OFFSET);
            out.writeObject((Object)naturalIdValues);
            out.writeUTF(entityName);
            out.writeUTF(tenantId);
            out.writeInt(hashCode);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public Object read(ObjectDataInput in) throws IOException {
        try {
            Serializable[] key = (Serializable[])in.readObject();
            String entityName = in.readUTF();
            String tenantId = in.readUTF();
            int hashCode = in.readInt();
            Object cacheKey = UnsafeHelper.UNSAFE.allocateInstance(CACHE_KEY_CLASS);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, NATURAL_ID_VALUES_OFFSET, key);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, ENTITY_NAME_OFFSET, entityName);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, TENANT_ID_OFFSET, tenantId);
            UnsafeHelper.UNSAFE.putIntVolatile(cacheKey, HASH_CODE_OFFSET, hashCode);
            return cacheKey;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public int getTypeId() {
        return -206;
    }

    public void destroy() {
    }

    static {
        try {
            CACHE_KEY_CLASS = Class.forName("org.hibernate.cache.internal.OldNaturalIdCacheKey");
            Field key = CACHE_KEY_CLASS.getDeclaredField("naturalIdValues");
            NATURAL_ID_VALUES_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(key);
            Field type = CACHE_KEY_CLASS.getDeclaredField("entityName");
            ENTITY_NAME_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(type);
            Field tenantId = CACHE_KEY_CLASS.getDeclaredField("tenantId");
            TENANT_ID_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(tenantId);
            Field hashCode = CACHE_KEY_CLASS.getDeclaredField("hashCode");
            HASH_CODE_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(hashCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

