/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.lang.reflect.Field;

class Hibernate5CacheKeySerializer
implements StreamSerializer<Object> {
    private static final Class<?> CACHE_KEY_CLASS;
    private static final long KEY_OFFSET;
    private static final long TYPE_OFFSET;
    private static final long ENTITY_OR_ROLE_NAME_OFFSET;
    private static final long TENANT_ID_OFFSET;
    private static final long HASH_CODE_OFFSET;

    Hibernate5CacheKeySerializer() {
    }

    public void write(ObjectDataOutput out, Object object) throws IOException {
        try {
            Object key = UnsafeHelper.UNSAFE.getObject(object, KEY_OFFSET);
            Object type = UnsafeHelper.UNSAFE.getObject(object, TYPE_OFFSET);
            String entityOrRoleName = (String)UnsafeHelper.UNSAFE.getObject(object, ENTITY_OR_ROLE_NAME_OFFSET);
            String tenantId = (String)UnsafeHelper.UNSAFE.getObject(object, TENANT_ID_OFFSET);
            int hashCode = UnsafeHelper.UNSAFE.getInt(object, HASH_CODE_OFFSET);
            out.writeObject(key);
            out.writeObject(type);
            out.writeUTF(entityOrRoleName);
            out.writeUTF(tenantId);
            out.writeInt(hashCode);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public Object read(ObjectDataInput in) throws IOException {
        try {
            Object key = in.readObject();
            Object type = in.readObject();
            String entityOrRoleName = in.readUTF();
            String tenantId = in.readUTF();
            int hashCode = in.readInt();
            Object cacheKey = UnsafeHelper.UNSAFE.allocateInstance(CACHE_KEY_CLASS);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, KEY_OFFSET, key);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, TYPE_OFFSET, type);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, ENTITY_OR_ROLE_NAME_OFFSET, entityOrRoleName);
            UnsafeHelper.UNSAFE.putObjectVolatile(cacheKey, TENANT_ID_OFFSET, tenantId);
            UnsafeHelper.UNSAFE.putIntVolatile(cacheKey, HASH_CODE_OFFSET, hashCode);
            return cacheKey;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public int getTypeId() {
        return -204;
    }

    public void destroy() {
    }

    static {
        try {
            CACHE_KEY_CLASS = Class.forName("org.hibernate.cache.internal.OldCacheKeyImplementation");
            Field key = CACHE_KEY_CLASS.getDeclaredField("id");
            KEY_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(key);
            Field type = CACHE_KEY_CLASS.getDeclaredField("type");
            TYPE_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(type);
            Field entityOrRoleName = CACHE_KEY_CLASS.getDeclaredField("entityOrRoleName");
            ENTITY_OR_ROLE_NAME_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(entityOrRoleName);
            Field tenantId = CACHE_KEY_CLASS.getDeclaredField("tenantId");
            TENANT_ID_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(tenantId);
            Field hashCode = CACHE_KEY_CLASS.getDeclaredField("hashCode");
            HASH_CODE_OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(hashCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

