/*
 * Decompiled with CFR 0.152.
 */
package com.haulmont.yarg.structure;

import com.haulmont.yarg.structure.BandOrientation;
import com.haulmont.yarg.structure.BandVisitor;
import com.haulmont.yarg.structure.ReportFieldFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BandData
implements Serializable {
    public static final String ROOT_BAND_NAME = "Root";
    protected Map<String, Object> data = new HashMap<String, Object>();
    protected BandData parentBand;
    protected Map<String, List<BandData>> childrenBands = new LinkedHashMap<String, List<BandData>>();
    protected final String name;
    protected final BandOrientation orientation;
    protected Set<String> firstLevelBandDefinitionNames = null;
    protected int level;
    protected Map<String, ReportFieldFormat> reportFieldFormats = new HashMap<String, ReportFieldFormat>();

    public BandData(String name) {
        this(name, null, BandOrientation.HORIZONTAL);
    }

    public BandData(String name, BandData parentBand) {
        this(name, parentBand, BandOrientation.HORIZONTAL);
    }

    public BandData(String name, BandData parentBand, BandOrientation orientation) {
        this.name = name;
        this.parentBand = parentBand;
        this.orientation = orientation;
        BandData currentBand = this;
        while (currentBand != null) {
            ++this.level;
            currentBand = currentBand.parentBand;
        }
    }

    public Map<String, List<BandData>> getChildrenBands() {
        return this.childrenBands;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void addData(String name, Object value) {
        this.data.put(name, value);
    }

    public Object getParameterValue(String name) {
        return this.data.get(name);
    }

    public Object getParameter(String name) {
        return this.getParameterValue(name);
    }

    public void addAllParameters(Map<String, Object> parameters) {
        this.data.putAll(parameters);
    }

    public String getName() {
        return this.name;
    }

    public BandData getParentBand() {
        return this.parentBand;
    }

    public void setParentBand(BandData parentBand) {
        this.parentBand = parentBand;
    }

    public BandOrientation getOrientation() {
        return this.orientation;
    }

    public int getLevel() {
        return this.level;
    }

    public String getFullName() {
        String fullName = this.name;
        BandData upBand = this.parentBand;
        while (upBand != null && upBand.level > 1) {
            fullName = upBand.getName() + "." + fullName;
            upBand = upBand.parentBand;
        }
        return fullName;
    }

    public List<BandData> getChildrenList() {
        ArrayList<BandData> bandList = new ArrayList<BandData>();
        for (List<BandData> bands : this.childrenBands.values()) {
            bandList.addAll(bands);
        }
        return bandList;
    }

    public List<BandData> getChildrenByName(String bandName) {
        if (bandName == null) {
            throw new NullPointerException("Parameter bandName can not be null.");
        }
        ArrayList children = this.childrenBands.get(bandName);
        return children != null ? children : new ArrayList();
    }

    public BandData getChildByName(String bandName) {
        if (bandName == null) {
            throw new NullPointerException("Parameter bandName can not be null.");
        }
        List<BandData> childrenByName = this.getChildrenByName(bandName);
        return childrenByName.isEmpty() ? null : childrenByName.get(0);
    }

    public void addChild(BandData band) {
        if (!this.childrenBands.containsKey(band.getName())) {
            this.childrenBands.put(band.getName(), new ArrayList());
        }
        List<BandData> bands = this.childrenBands.get(band.getName());
        bands.add(band);
    }

    public void addChildren(List<BandData> bands) {
        for (BandData band : bands) {
            this.addChild(band);
        }
    }

    public boolean visit(BandVisitor bandVisitor) {
        if (bandVisitor.visit(this)) {
            return true;
        }
        for (BandData child : this.getChildrenList()) {
            if (!child.visit(bandVisitor)) continue;
            return true;
        }
        return false;
    }

    public BandData findBandRecursively(String name) {
        BandNameVisitor visitor = new BandNameVisitor(name);
        this.visit(visitor);
        return visitor.foundBand;
    }

    public List<BandData> findBandsRecursively(String name) {
        BandData firstBand = this.findBandRecursively(name);
        if (firstBand == null) {
            return Collections.emptyList();
        }
        List<BandData> allBands = firstBand.getParentBand() != null ? firstBand.getParentBand().getChildrenByName(name) : Collections.singletonList(firstBand);
        return allBands;
    }

    public Set<String> getFirstLevelBandDefinitionNames() {
        return this.firstLevelBandDefinitionNames;
    }

    public void setFirstLevelBandDefinitionNames(Set<String> firstLevelBandDefinitionNames) {
        this.firstLevelBandDefinitionNames = firstLevelBandDefinitionNames;
    }

    public void addReportFieldFormats(List<ReportFieldFormat> reportFieldFormats) {
        for (ReportFieldFormat reportFieldFormat : reportFieldFormats) {
            this.reportFieldFormats.put(reportFieldFormat.getName(), reportFieldFormat);
        }
    }

    public Map<String, ReportFieldFormat> getReportFieldFormats() {
        return this.reportFieldFormats;
    }

    public String toString() {
        StringBuilder sbf = new StringBuilder();
        sbf.append(this.name).append(":").append(this.data.toString()).append("\n");
        for (BandData band : this.getChildrenList()) {
            for (int i = 0; i < this.level; ++i) {
                sbf.append("\t");
            }
            sbf.append(band.toString());
        }
        return sbf.toString();
    }

    protected static class BandNameVisitor
    implements BandVisitor {
        protected String name;
        protected BandData foundBand;

        public BandNameVisitor(String name) {
            if (name == null) {
                throw new NullPointerException("Could not find band with name = null");
            }
            this.name = name;
        }

        @Override
        public boolean visit(BandData band) {
            boolean found = band.getName().equals(this.name);
            if (found) {
                this.foundBand = band;
            }
            return found;
        }
    }
}

