/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.endpoint;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class JaxRsEndpointDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String JAXRS_ENDPOINT_TYPE = "JAXRS_ENDPOINT";
    private BugReporter bugReporter;

    public JaxRsEndpointDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : javaClass.getMethods()) {
            for (AnnotationEntry ae : m.getAnnotationEntries()) {
                if (!this.isRsEndpointAnnotation(ae)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, JAXRS_ENDPOINT_TYPE, 3).addClassAndMethod(javaClass, m));
            }
        }
    }

    private boolean isRsEndpointAnnotation(AnnotationEntry ae) {
        return ae.getAnnotationType().equals("Ljavax/ws/rs/Path;") || ae.getAnnotationType().equals("Ljakarta/ws/rs/Path;");
    }

    public void report() {
    }
}

