/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.cookie;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class CookieFlagsDetector
implements Detector {
    private static final String INSECURE_COOKIE_TYPE = "INSECURE_COOKIE";
    private static final String HTTPONLY_COOKIE_TYPE = "HTTPONLY_COOKIE";
    private BugReporter bugReporter;
    private static final int TRUE_INT_VALUE = 1;

    public CookieFlagsDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            JavaClass javaClass;
            Instruction cookieStoreInstruction;
            INVOKESPECIAL invoke;
            Location loc = (Location)i.next();
            Instruction inst = loc.getHandle().getInstruction();
            if (!(inst instanceof INVOKESPECIAL) || !this.isCookieClass(invoke = (INVOKESPECIAL)inst, cpg) || !"<init>".equals(invoke.getMethodName(cpg)) || !((cookieStoreInstruction = loc.getHandle().getNext().getInstruction()) instanceof ASTORE)) continue;
            ASTORE storeInstruction = (ASTORE)cookieStoreInstruction;
            if (!this.isSecureFlagSet(cpg, loc, storeInstruction.getIndex())) {
                javaClass = classContext.getJavaClass();
                this.bugReporter.reportBug(new BugInstance((Detector)this, INSECURE_COOKIE_TYPE, 2).addClass(javaClass).addMethod(javaClass, m).addSourceLine(classContext, m, loc));
            }
            if (this.isHttpOnlyFlagSet(cpg, loc, storeInstruction.getIndex())) continue;
            javaClass = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, HTTPONLY_COOKIE_TYPE, 2).addClass(javaClass).addMethod(javaClass, m).addSourceLine(classContext, m, loc));
        }
    }

    private boolean isCookieClass(INVOKESPECIAL invoke, ConstantPoolGen cpg) {
        return "javax.servlet.http.Cookie".equals(invoke.getClassName(cpg)) || "jakarta.servlet.http.Cookie".equals(invoke.getClassName(cpg));
    }

    private Location getCookieInstructionLocation(ConstantPoolGen cpg, Location startLocation, int objectStackLocation, String invokeInstruction) {
        Location location = startLocation;
        InstructionHandle handle = location.getHandle();
        int loadedStackValue = 0;
        while (handle.getNext() != null) {
            Integer val;
            INVOKEVIRTUAL invoke;
            String methodNameWithSignature;
            Instruction nextInst = (handle = handle.getNext()).getInstruction();
            if (nextInst instanceof ALOAD) {
                ALOAD loadInst = (ALOAD)nextInst;
                loadedStackValue = loadInst.getIndex();
            }
            if (!(nextInst instanceof INVOKEVIRTUAL) || loadedStackValue != objectStackLocation || !(methodNameWithSignature = (invoke = (INVOKEVIRTUAL)nextInst).getClassName(cpg) + "." + invoke.getMethodName(cpg)).equals(invokeInstruction) || (val = ByteCode.getConstantInt(handle.getPrev())) == null || val != 1) continue;
            return new Location(handle, location.getBasicBlock());
        }
        return null;
    }

    private boolean isSecureFlagSet(ConstantPoolGen cpg, Location startLocation, int stackLocation) {
        Location javaxSetSecureLocation = this.getCookieInstructionLocation(cpg, startLocation, stackLocation, "javax.servlet.http.Cookie.setSecure");
        Location jakartaSetSecureLocation = this.getCookieInstructionLocation(cpg, startLocation, stackLocation, "jakarta.servlet.http.Cookie.setSecure");
        return javaxSetSecureLocation != null || jakartaSetSecureLocation != null;
    }

    private boolean isHttpOnlyFlagSet(ConstantPoolGen cpg, Location startLocation, int stackLocation) {
        Location javaxSetHttpOnlyLocation = this.getCookieInstructionLocation(cpg, startLocation, stackLocation, "javax.servlet.http.Cookie.setHttpOnly");
        Location jakartaHttpOnlyLocation = this.getCookieInstructionLocation(cpg, startLocation, stackLocation, "jakarta.servlet.http.Cookie.setHttpOnly");
        return javaxSetHttpOnlyLocation != null || jakartaHttpOnlyLocation != null;
    }

    public void report() {
    }
}

