/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassName;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.InvokeInstruction;

public class BCELUtil {
    public static final String INVOKEDYNAMIC_GENERIC_CLASSNAME = Object.class.getName();
    private static Map<String, SoftReference<Set<String>>> superMap = Collections.synchronizedMap(new HashMap());

    public static String getSlashedClassName(ConstantPoolGen cpg, FieldOrMethod obj) {
        if (186 == obj.getOpcode()) {
            return INVOKEDYNAMIC_GENERIC_CLASSNAME;
        }
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP invokeConstant = (ConstantCP)cp.getConstant(obj.getIndex());
        return cp.getConstantString(invokeConstant.getClassIndex(), (byte)7);
    }

    public static String getSlashedClassName(JavaClass javaClass) {
        ConstantPool cp = javaClass.getConstantPool();
        int classNameIndex = javaClass.getClassNameIndex();
        return cp.getConstantString(classNameIndex, (byte)7);
    }

    public static Set<String> getParentClassNames(JavaClass javaClass) {
        Set<String> classNames;
        String key = javaClass.getClassName();
        SoftReference<Set<String>> reference = superMap.get(key);
        Set<String> set = classNames = reference == null ? null : reference.get();
        if (classNames == null) {
            classNames = new HashSet<String>();
            LinkedList<JavaClass> queue = new LinkedList<JavaClass>();
            queue.offer(javaClass);
            while (!queue.isEmpty()) {
                JavaClass clazz = (JavaClass)queue.poll();
                if (clazz != javaClass) {
                    classNames.add(BCELUtil.getSlashedClassName(clazz));
                }
                try {
                    JavaClass superClass = clazz.getSuperClass();
                    if (superClass != null) {
                        queue.offer(superClass);
                    }
                }
                catch (ClassNotFoundException ex) {
                    AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
                    classNames.add(ClassName.toSlashedClassName((String)clazz.getSuperclassName()));
                }
                try {
                    for (JavaClass interfaceClass : clazz.getInterfaces()) {
                        queue.offer(interfaceClass);
                    }
                }
                catch (ClassNotFoundException ex) {
                    AnalysisContext.reportMissingClass((ClassNotFoundException)ex);
                    for (String interfaceClassName : clazz.getInterfaceNames()) {
                        classNames.add(ClassName.toSlashedClassName((String)interfaceClassName));
                    }
                }
            }
            superMap.put(key, new SoftReference<Set<String>>(classNames));
        }
        return classNames;
    }

    public static int getNumArgumentsIncludingObjectInstance(InvokeInstruction obj, ConstantPoolGen cpg) {
        String signature = obj.getSignature(cpg);
        int count = 1;
        if (obj.getOpcode() == 184 || obj.getOpcode() == 186) {
            count = 0;
        }
        block7: for (int i = 0; i < signature.length(); ++i) {
            switch (signature.charAt(i)) {
                case '(': {
                    continue block7;
                }
                case ')': {
                    return count;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++count;
                    continue block7;
                }
                case 'L': {
                    int semi = signature.indexOf(59, i + 1);
                    if (semi < 0) {
                        throw new IllegalStateException("Invalid method signature: " + signature);
                    }
                    i = semi;
                    ++count;
                    continue block7;
                }
                case '[': {
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Invalid method signature, unknown character " + signature.charAt(i) + " in " + signature);
                }
            }
        }
        return count;
    }
}

