/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.scala;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import edu.umd.cs.findbugs.BugReporter;

public class XssTwirlDetector
extends BasicInjectionDetector {
    private static final String SCALA_XSS_TWIRL_TYPE = "SCALA_XSS_TWIRL";

    public XssTwirlDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-scala-twirl.txt", SCALA_XSS_TWIRL_TYPE);
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.XSS_SAFE)) {
            if (FindSecBugsGlobalConfig.getInstance().isReportPotentialXssWrongContext()) {
                return 3;
            }
            return 5;
        }
        if (!taint.isSafe() && taint.hasOneTag(Taint.Tag.QUOTE_ENCODED, Taint.Tag.APOSTROPHE_ENCODED) && taint.hasTag(Taint.Tag.LT_ENCODED)) {
            return 3;
        }
        return super.getPriority(taint);
    }
}

