/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.server.TcpServer;
import org.h2.util.SmallMap;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class TcpServerThread
implements Runnable {
    private TcpServer server;
    private Session session;
    private boolean stop;
    private Thread thread;
    private Transfer transfer;
    private Command commit;
    private SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);
    private int threadId;
    private int clientVersion;
    private String sessionId;

    TcpServerThread(Socket socket, TcpServer tcpServer, int n) {
        this.server = tcpServer;
        this.threadId = n;
        this.transfer = new Transfer(null);
        this.transfer.setSocket(socket);
    }

    private void trace(String string) {
        this.server.trace(this + " " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.transfer.init();
            this.trace("Connect");
            try {
                int n;
                String string;
                if (!this.server.allow(this.transfer.getSocket())) {
                    throw DbException.get(90117);
                }
                this.clientVersion = this.transfer.readInt();
                if (this.clientVersion < 6) {
                    throw DbException.get(90047, "current client version: " + this.clientVersion + "; minimum version: " + 6);
                }
                this.transfer.readInt();
                String string2 = this.transfer.readString();
                String string3 = this.transfer.readString();
                if (string2 == null && string3 == null) {
                    string = this.transfer.readString();
                    int n2 = this.transfer.readInt();
                    this.stop = true;
                    if (n2 == 13) {
                        n = this.transfer.readInt();
                        this.server.cancelStatement(string, n);
                    } else if (n2 == 14) {
                        string2 = this.server.checkKeyAndGetDatabaseName(string);
                        if (!string.equals(string2)) {
                            this.transfer.writeInt(1);
                        } else {
                            this.transfer.writeInt(0);
                        }
                    }
                }
                if ((string = this.server.getBaseDir()) == null) {
                    string = SysProperties.getBaseDir();
                }
                string2 = this.server.checkKeyAndGetDatabaseName(string2);
                ConnectionInfo connectionInfo = new ConnectionInfo(string2);
                if (string != null) {
                    connectionInfo.setBaseDir(string);
                }
                if (this.server.getIfExists()) {
                    connectionInfo.setProperty("IFEXISTS", "TRUE");
                }
                connectionInfo.setOriginalURL(string3);
                connectionInfo.setUserName(this.transfer.readString());
                connectionInfo.setUserPasswordHash(this.transfer.readBytes());
                connectionInfo.setFilePasswordHash(this.transfer.readBytes());
                n = this.transfer.readInt();
                for (int i = 0; i < n; ++i) {
                    connectionInfo.setProperty(this.transfer.readString(), this.transfer.readString());
                }
                Engine engine = Engine.getInstance();
                this.session = engine.getSession(connectionInfo);
                this.transfer.setSession(this.session);
                this.transfer.writeInt(1);
                if (this.clientVersion >= 6) {
                    this.transfer.writeInt(6);
                }
                this.transfer.flush();
                this.server.addConnection(this.threadId, string3, connectionInfo.getUserName());
                this.trace("Connected");
            }
            catch (Throwable throwable) {
                this.sendError(throwable);
                this.stop = true;
            }
            while (!this.stop) {
                try {
                    this.process();
                }
                catch (Throwable throwable) {
                    this.sendError(throwable);
                }
            }
            this.trace("Disconnect");
        }
        catch (Throwable throwable) {
            this.server.traceError(throwable);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session != null) {
            try {
                Command command = this.session.prepareLocal("ROLLBACK");
                command.executeUpdate();
            }
            catch (Exception exception) {
                this.server.traceError(exception);
            }
            try {
                this.session.close();
                this.server.removeConnection(this.threadId);
            }
            catch (Exception exception) {
                this.server.traceError(exception);
            }
            finally {
                this.session = null;
            }
        }
    }

    void close() {
        try {
            this.stop = true;
            this.closeSession();
            this.transfer.close();
            this.trace("Close");
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        this.server.remove(this);
    }

    private void sendError(Throwable throwable) {
        try {
            String string;
            String string2;
            SQLException sQLException = DbException.convert(throwable).getSQLException();
            StringWriter stringWriter = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(stringWriter));
            String string3 = stringWriter.toString();
            if (sQLException instanceof JdbcSQLException) {
                JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
                string2 = jdbcSQLException.getOriginalMessage();
                string = jdbcSQLException.getSQL();
            } else {
                string2 = sQLException.getMessage();
                string = null;
            }
            this.transfer.writeInt(0).writeString(sQLException.getSQLState()).writeString(string2).writeString(string).writeInt(sQLException.getErrorCode()).writeString(string3).flush();
        }
        catch (IOException iOException) {
            this.server.traceError(iOException);
            this.stop = true;
        }
    }

    private void setParameters(Command command) throws IOException {
        int n = this.transfer.readInt();
        ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = (Parameter)arrayList.get(i);
            parameter.setValue(this.transfer.readValue());
        }
    }

    private void process() throws IOException, SQLException {
        int n = this.transfer.readInt();
        switch (n) {
            case 0: 
            case 11: {
                int n2 = this.transfer.readInt();
                String string = this.transfer.readString();
                int n3 = this.session.getModificationId();
                Command command = this.session.prepareLocal(string);
                boolean bl = command.isReadOnly();
                this.cache.addObject(n2, command);
                boolean bl2 = command.isQuery();
                ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
                this.transfer.writeInt(this.getState(n3)).writeBoolean(bl2).writeBoolean(bl).writeInt(arrayList.size());
                if (n == 11) {
                    for (ParameterInterface parameterInterface : arrayList) {
                        ParameterRemote.writeMetaData(this.transfer, parameterInterface);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 1: {
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = this.session.prepareLocal("COMMIT");
                }
                int n4 = this.session.getModificationId();
                this.commit.executeUpdate();
                this.transfer.writeInt(this.getState(n4)).flush();
                break;
            }
            case 10: {
                int n5 = this.transfer.readInt();
                int n6 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n5, false);
                ResultInterface resultInterface = command.getMetaData();
                this.cache.addObject(n6, resultInterface);
                int n7 = resultInterface.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(n7).writeInt(0);
                for (int i = 0; i < n7; ++i) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, i);
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                int n8;
                int n9 = this.transfer.readInt();
                int n10 = this.transfer.readInt();
                int n11 = this.transfer.readInt();
                int n12 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n9, false);
                this.setParameters(command);
                int n13 = this.session.getModificationId();
                ResultInterface resultInterface = command.executeQuery(n11, false);
                this.cache.addObject(n10, resultInterface);
                int n14 = resultInterface.getVisibleColumnCount();
                int n15 = this.getState(n13);
                this.transfer.writeInt(n15).writeInt(n14);
                int n16 = resultInterface.getRowCount();
                this.transfer.writeInt(n16);
                for (n8 = 0; n8 < n14; ++n8) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, n8);
                }
                n8 = Math.min(n16, n12);
                for (int i = 0; i < n8; ++i) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 3: {
                int n17 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n17, false);
                this.setParameters(command);
                int n18 = this.session.getModificationId();
                int n19 = command.executeUpdate();
                int n20 = this.session.isClosed() ? 2 : this.getState(n18);
                this.transfer.writeInt(n20).writeInt(n19).writeBoolean(this.session.getAutoCommit());
                this.transfer.flush();
                break;
            }
            case 4: {
                int n21 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n21, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(n21);
                break;
            }
            case 5: {
                int n22 = this.transfer.readInt();
                int n23 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n22, false);
                this.transfer.writeInt(1);
                for (int i = 0; i < n23; ++i) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 6: {
                int n24 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n24, false);
                resultInterface.reset();
                break;
            }
            case 7: {
                int n25 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n25, true);
                if (resultInterface == null) break;
                resultInterface.close();
                this.cache.freeObject(n25);
                break;
            }
            case 9: {
                int n26 = this.transfer.readInt();
                int n27 = this.transfer.readInt();
                Object object = this.cache.getObject(n26, false);
                this.cache.freeObject(n26);
                this.cache.addObject(n27, object);
                break;
            }
            case 12: {
                this.sessionId = this.transfer.readString();
                this.transfer.writeInt(1).flush();
                break;
            }
            default: {
                this.trace("Unknown operation: " + n);
                this.closeSession();
                this.close();
            }
        }
    }

    private int getState(int n) {
        if (this.session.getModificationId() == n) {
            return 1;
        }
        return 3;
    }

    private void sendRow(ResultInterface resultInterface) throws IOException {
        if (resultInterface.next()) {
            this.transfer.writeBoolean(true);
            Value[] valueArray = resultInterface.currentRow();
            for (int i = 0; i < resultInterface.getVisibleColumnCount(); ++i) {
                this.transfer.writeValue(valueArray[i]);
            }
        } else {
            this.transfer.writeBoolean(false);
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void cancelStatement(String string, int n) throws SQLException {
        if (StringUtils.equals(string, this.sessionId)) {
            Command command = (Command)this.cache.getObject(n, false);
            command.cancel();
        }
    }
}

