/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.server.web.DbSchema;
import org.h2.util.StringUtils;

public class DbContents {
    DbSchema[] schemas;
    DbSchema defaultSchema;
    boolean isOracle;
    boolean isH2;
    boolean isPostgreSQL;
    boolean isMySQL;
    boolean isDerby;
    boolean isFirebird;
    boolean isSQLite;

    void readContents(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = StringUtils.toLowerEnglish(databaseMetaData.getDatabaseProductName());
        this.isSQLite = string.indexOf("sqlite") >= 0;
        String string2 = databaseMetaData.getURL();
        if (string2 != null) {
            this.isH2 = string2.startsWith("jdbc:h2:");
            this.isOracle = string2.startsWith("jdbc:oracle:");
            this.isPostgreSQL = string2.startsWith("jdbc:postgresql:");
            this.isMySQL = string2.startsWith("jdbc:mysql:");
            this.isDerby = string2.startsWith("jdbc:derby:");
            this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
        }
        String string3 = this.getDefaultSchemaName(databaseMetaData);
        String[] stringArray = this.getSchemaNames(databaseMetaData);
        this.schemas = new DbSchema[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            boolean bl = string3 == null || string3.equals(string4);
            DbSchema dbSchema = new DbSchema(this, string4, bl);
            if (dbSchema.isDefault) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i] = dbSchema;
            String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM"};
            dbSchema.readTables(databaseMetaData, stringArray2);
        }
        if (this.defaultSchema == null) {
            String string5 = null;
            for (int i = 0; i < this.schemas.length; ++i) {
                if ("dbo".equals(this.schemas[i].name)) {
                    this.defaultSchema = this.schemas[i];
                    break;
                }
                if (this.defaultSchema != null && string5 != null && this.schemas[i].name.length() >= string5.length()) continue;
                string5 = this.schemas[i].name;
                this.defaultSchema = this.schemas[i];
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray;
        if (this.isMySQL) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (resultSet.next()) {
            stringArray = resultSet.getString("TABLE_SCHEM");
            if (stringArray == null) continue;
            arrayList.add(stringArray);
        }
        resultSet.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    String quoteIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (this.isH2) {
            return Parser.quoteIdentifier(string);
        }
        return StringUtils.toUpperEnglish(string);
    }
}

