/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class InstructionSequenceMatcher
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MORE = false;
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    public static final int E = 0x40000007;
    public static final int F = 0x40000008;
    public static final int G = 0x40000009;
    public static final int H = 0x4000000A;
    public static final int I = 0x4000000B;
    public static final int J = 0x4000000C;
    public static final int K = 0x4000000D;
    public static final int L = 0x4000000E;
    public static final int M = 0x4000000F;
    public static final int N = 0x40000010;
    public static final int O = 0x40000011;
    public static final int P = 1073741842;
    public static final int Q = 1073741843;
    public static final int R = 0x40000014;
    protected final Constant[] patternConstants;
    protected final Instruction[] patternInstructions;
    private boolean matching;
    private int patternInstructionIndex;
    private final int[] matchedInstructionOffsets;
    private int matchedArgumentFlags;
    private final int[] matchedArguments = new int[21];
    private final long[] matchedConstantFlags;
    private final int[] matchedConstantIndices;
    private int constantFlags;
    private int previousConstantFlags;
    private final boolean matchSubclasses;
    protected Constant patternConstant;
    protected boolean matchingConstant;

    public InstructionSequenceMatcher(Constant[] patternConstants, Instruction[] patternInstructions) {
        this(patternConstants, patternInstructions, false);
    }

    public InstructionSequenceMatcher(Constant[] patternConstants, Instruction[] patternInstructions, boolean matchSubclasses) {
        this.patternConstants = patternConstants;
        this.patternInstructions = patternInstructions;
        this.matchedInstructionOffsets = new int[patternInstructions.length];
        this.matchedConstantFlags = new long[(patternConstants.length + 63) / 64];
        this.matchedConstantIndices = new int[patternConstants.length];
        this.matchSubclasses = matchSubclasses;
    }

    public void reset() {
        this.patternInstructionIndex = 0;
        this.matchedArgumentFlags = 0;
        Arrays.fill(this.matchedConstantFlags, 0L);
        this.previousConstantFlags = this.constantFlags;
        this.constantFlags = 0;
    }

    public boolean isMatching() {
        return this.matching;
    }

    public int instructionCount() {
        return this.patternInstructions.length;
    }

    public int matchedInstructionOffset(int index) {
        return this.matchedInstructionOffsets[index];
    }

    public boolean wasConstant(int argument) {
        return (this.previousConstantFlags & 1 << argument - 0x40000000) != 0;
    }

    public int matchedArgument(int argument) {
        int argumentIndex = argument - 0x40000000;
        return argumentIndex < 0 ? argument : this.matchedArguments[argumentIndex];
    }

    public int[] matchedArguments(int[] arguments) {
        int[] matchedArguments = new int[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            matchedArguments[index] = this.matchedArgument(arguments[index]);
        }
        return matchedArguments;
    }

    public int matchedConstantIndex(int constantIndex) {
        int argumentIndex = constantIndex - 0x40000000;
        return argumentIndex < 0 ? this.matchedConstantIndices[constantIndex] : this.matchedArguments[argumentIndex];
    }

    public int matchedBranchOffset(int offset, int branchOffset) {
        int argumentIndex = branchOffset - 0x40000000;
        return argumentIndex < 0 ? branchOffset : this.matchedArguments[argumentIndex] - offset;
    }

    public int[] matchedJumpOffsets(int offset, int[] jumpOffsets) {
        int[] matchedJumpOffsets = new int[jumpOffsets.length];
        for (int index = 0; index < jumpOffsets.length; ++index) {
            matchedJumpOffsets[index] = this.matchedBranchOffset(offset, jumpOffsets[index]);
        }
        return matchedJumpOffsets;
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(simpleInstruction, patternInstruction) && this.matchingArguments(simpleInstruction.constant, ((SimpleInstruction)patternInstruction).constant);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, simpleInstruction);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(variableInstruction, patternInstruction) && this.matchingArguments(variableInstruction.variableIndex, ((VariableInstruction)patternInstruction).variableIndex) && this.matchingArguments(variableInstruction.constant, ((VariableInstruction)patternInstruction).constant);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, variableInstruction);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(constantInstruction, patternInstruction) && this.matchingConstantIndices(clazz, constantInstruction.constantIndex, ((ConstantInstruction)patternInstruction).constantIndex) && this.matchingArguments(constantInstruction.constant, ((ConstantInstruction)patternInstruction).constant);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, constantInstruction);
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(branchInstruction, patternInstruction) && this.matchingBranchOffsets(offset, branchInstruction.branchOffset, ((BranchInstruction)patternInstruction).branchOffset);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, branchInstruction);
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(tableSwitchInstruction, patternInstruction) && this.matchingBranchOffsets(offset, tableSwitchInstruction.defaultOffset, ((TableSwitchInstruction)patternInstruction).defaultOffset) && this.matchingArguments(tableSwitchInstruction.lowCase, ((TableSwitchInstruction)patternInstruction).lowCase) && this.matchingArguments(tableSwitchInstruction.highCase, ((TableSwitchInstruction)patternInstruction).highCase) && this.matchingJumpOffsets(offset, tableSwitchInstruction.jumpOffsets, ((TableSwitchInstruction)patternInstruction).jumpOffsets);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, tableSwitchInstruction);
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        Instruction patternInstruction = this.patternInstructions[this.patternInstructionIndex];
        boolean condition = this.matchingOpcodes(lookUpSwitchInstruction, patternInstruction) && this.matchingBranchOffsets(offset, lookUpSwitchInstruction.defaultOffset, ((LookUpSwitchInstruction)patternInstruction).defaultOffset) && this.matchingArguments(lookUpSwitchInstruction.cases, ((LookUpSwitchInstruction)patternInstruction).cases) && this.matchingJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets, ((LookUpSwitchInstruction)patternInstruction).jumpOffsets);
        this.checkMatch(condition, clazz, method, codeAttribute, offset, lookUpSwitchInstruction);
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        IntegerConstant integerPatternConstant = (IntegerConstant)this.patternConstant;
        this.matchingConstant = integerConstant.getValue() == integerPatternConstant.getValue();
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        LongConstant longPatternConstant = (LongConstant)this.patternConstant;
        this.matchingConstant = longConstant.getValue() == longPatternConstant.getValue();
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        FloatConstant floatPatternConstant = (FloatConstant)this.patternConstant;
        this.matchingConstant = floatConstant.getValue() == floatPatternConstant.getValue();
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        DoubleConstant doublePatternConstant = (DoubleConstant)this.patternConstant;
        this.matchingConstant = doubleConstant.getValue() == doublePatternConstant.getValue();
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        StringConstant stringPatternConstant = (StringConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, stringConstant.u2stringIndex, stringPatternConstant.u2stringIndex);
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        Utf8Constant utf8PatternConstant = (Utf8Constant)this.patternConstant;
        this.matchingConstant = utf8Constant.getString().equals(utf8PatternConstant.getString());
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        DynamicConstant dynamicPatternConstant = (DynamicConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, dynamicConstant.getBootstrapMethodAttributeIndex(), dynamicPatternConstant.getBootstrapMethodAttributeIndex()) && this.matchingConstantIndices(clazz, dynamicConstant.getNameAndTypeIndex(), dynamicPatternConstant.getNameAndTypeIndex());
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        InvokeDynamicConstant invokeDynamicPatternConstant = (InvokeDynamicConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, invokeDynamicConstant.getBootstrapMethodAttributeIndex(), invokeDynamicPatternConstant.getBootstrapMethodAttributeIndex()) && this.matchingConstantIndices(clazz, invokeDynamicConstant.getNameAndTypeIndex(), invokeDynamicPatternConstant.getNameAndTypeIndex());
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        MethodHandleConstant methodHandlePatternConstant = (MethodHandleConstant)this.patternConstant;
        this.matchingConstant = this.matchingArguments(methodHandleConstant.getReferenceKind(), methodHandlePatternConstant.getReferenceKind()) && this.matchingConstantIndices(clazz, methodHandleConstant.getReferenceIndex(), methodHandlePatternConstant.getReferenceIndex());
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant refPatternConstant = (RefConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, refConstant.getClassIndex(), refPatternConstant.getClassIndex());
        if (!this.matchingConstant && this.matchSubclasses && refConstant.referencedClass != null && refPatternConstant.referencedClass != null) {
            this.matchingConstant = refConstant.referencedClass.extendsOrImplements(refPatternConstant.referencedClass);
        }
        if (this.matchingConstant) {
            this.matchingConstant = this.matchingConstantIndices(clazz, refConstant.getNameAndTypeIndex(), refPatternConstant.getNameAndTypeIndex());
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        ClassConstant classPatternConstant = (ClassConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, classConstant.u2nameIndex, classPatternConstant.u2nameIndex);
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        MethodTypeConstant typePatternConstant = (MethodTypeConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, methodTypeConstant.u2descriptorIndex, typePatternConstant.u2descriptorIndex);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant typePatternConstant = (NameAndTypeConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, nameAndTypeConstant.u2nameIndex, typePatternConstant.u2nameIndex) && this.matchingConstantIndices(clazz, nameAndTypeConstant.u2descriptorIndex, typePatternConstant.u2descriptorIndex);
    }

    protected boolean matchingOpcodes(Instruction instruction1, Instruction instruction2) {
        return instruction1.opcode == instruction2.opcode || instruction1.canonicalOpcode() == instruction2.opcode;
    }

    protected boolean matchingArguments(int argument1, int argument2) {
        int argumentIndex = argument2 - 0x40000000;
        if (argumentIndex < 0) {
            return argument1 == argument2;
        }
        if (!this.isMatchingArgumentIndex(argumentIndex)) {
            this.setMatchingArgument(argumentIndex, argument1);
            return true;
        }
        return this.matchedArguments[argumentIndex] == argument1;
    }

    private void setMatchingArgument(int argumentIndex, int argument) {
        this.matchedArguments[argumentIndex] = argument;
        this.matchedArgumentFlags |= 1 << argumentIndex;
    }

    private boolean isMatchingArgumentIndex(int argumentIndex) {
        return (this.matchedArgumentFlags & 1 << argumentIndex) != 0;
    }

    protected boolean matchingArguments(int[] arguments1, int[] arguments2) {
        if (arguments1.length != arguments2.length) {
            return false;
        }
        for (int index = 0; index < arguments1.length; ++index) {
            if (this.matchingArguments(arguments1[index], arguments2[index])) continue;
            return false;
        }
        return true;
    }

    protected boolean matchingConstantIndices(Clazz clazz, int constantIndex1, int constantIndex2) {
        if (constantIndex2 >= 0x40000000) {
            this.constantFlags |= 1 << constantIndex2 - 0x40000000;
            return this.matchingArguments(constantIndex1, constantIndex2);
        }
        if (!this.isMatchingConstantIndex(constantIndex2)) {
            this.matchingConstant = false;
            this.patternConstant = this.patternConstants[constantIndex2];
            if (clazz.getTag(constantIndex1) == this.patternConstant.getTag()) {
                clazz.constantPoolEntryAccept(constantIndex1, this);
                if (this.matchingConstant) {
                    this.setMatchingConstant(constantIndex2, constantIndex1);
                }
            }
            return this.matchingConstant;
        }
        return this.matchedConstantIndices[constantIndex2] == constantIndex1;
    }

    private void setMatchingConstant(int constantIndex, int constantIndex1) {
        this.matchedConstantIndices[constantIndex] = constantIndex1;
        int n = constantIndex / 64;
        this.matchedConstantFlags[n] = this.matchedConstantFlags[n] | 1L << constantIndex;
    }

    private boolean isMatchingConstantIndex(int constantIndex) {
        return (this.matchedConstantFlags[constantIndex / 64] & 1L << constantIndex) != 0L;
    }

    protected boolean matchingBranchOffsets(int offset, int branchOffset1, int branchOffset2) {
        int argumentIndex = branchOffset2 - 0x40000000;
        if (argumentIndex < 0) {
            return branchOffset1 == branchOffset2;
        }
        if (!this.isMatchingArgumentIndex(argumentIndex)) {
            this.setMatchingArgument(argumentIndex, offset + branchOffset1);
            return true;
        }
        return this.matchedArguments[argumentIndex] == offset + branchOffset1;
    }

    protected boolean matchingJumpOffsets(int offset, int[] jumpOffsets1, int[] jumpOffsets2) {
        if (jumpOffsets1.length != jumpOffsets2.length) {
            return false;
        }
        for (int index = 0; index < jumpOffsets1.length; ++index) {
            if (this.matchingBranchOffsets(offset, jumpOffsets1[index], jumpOffsets2[index])) continue;
            return false;
        }
        return true;
    }

    private void checkMatch(boolean condition, Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (condition) {
            this.matchedInstructionOffsets[this.patternInstructionIndex] = offset;
            ++this.patternInstructionIndex;
            boolean bl = this.matching = this.patternInstructionIndex == this.patternInstructions.length;
            if (this.matching) {
                this.matching &= this.finalMatch(clazz, method, codeAttribute, offset, instruction);
                this.reset();
            }
        } else {
            this.matching = false;
            boolean retry = this.patternInstructionIndex == 1;
            this.reset();
            if (retry) {
                instruction.accept(clazz, method, codeAttribute, offset, this);
            }
        }
    }

    protected boolean finalMatch(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        return true;
    }

    public static void main(String[] args) {
        ProgramClass programClass = new ClassBuilder(0x2E0000, 1, "Test", "java/lang/Object").addMethod(1, "getAnswer", "()I", 50, code -> code.nop().iconst_2().bipush(40).iadd().ireturn()).getProgramClass();
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        builder.iconst(0x40000003).iconst(0x40000004).iadd();
        InstructionSequenceMatcher matcher = new InstructionSequenceMatcher(builder.constants(), builder.instructions());
        class MatchPrinter
        implements InstructionVisitor {
            MatchPrinter() {
            }

            @Override
            public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
                System.out.println(instruction.toString(clazz, offset));
                instruction.accept(clazz, method, codeAttribute, offset, InstructionSequenceMatcher.this);
                if (InstructionSequenceMatcher.this.isMatching()) {
                    System.out.println("  -> matching sequence starting at [" + InstructionSequenceMatcher.this.matchedInstructionOffset(0) + "]");
                }
            }
        }
        programClass.methodsAccept(new AllAttributeVisitor(new AllInstructionVisitor(matcher.new MatchPrinter())));
    }
}

