/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.MethodSignature;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.util.ClassUtil;

public class KotlinMetadataPrinter
implements KotlinMetadataVisitor,
KotlinConstructorVisitor,
KotlinTypeParameterVisitor,
KotlinTypeVisitor,
KotlinValueParameterVisitor,
KotlinVersionRequirementVisitor,
KotlinFunctionVisitor,
KotlinContractVisitor,
KotlinEffectVisitor,
KotlinTypeAliasVisitor,
KotlinPropertyVisitor,
KotlinEffectExprVisitor,
KotlinAnnotationVisitor {
    private static final String INDENTATION = "  ";
    public static final String DEFAULT_MISSING_REF_INDICATOR = "! ";
    private final PrintWriter pw;
    private int indentation;
    private String refMissingIndicator;

    public KotlinMetadataPrinter() {
        this(new PrintWriter(System.out, true), DEFAULT_MISSING_REF_INDICATOR);
    }

    public KotlinMetadataPrinter(PrintWriter pw) {
        this(pw, DEFAULT_MISSING_REF_INDICATOR);
    }

    public KotlinMetadataPrinter(PrintWriter pw, String refMissingIndicator) {
        this.pw = pw;
        this.refMissingIndicator = refMissingIndicator;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
        kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        this.println("_____________________________________________________________________");
        this.print(this.hasRefIndicator(kotlinClassKindMetadata.referencedClass) + "Kotlin " + this.classFlags(kotlinClassKindMetadata.flags) + "class(" + this.hasAnnotationsFlag(kotlinClassKindMetadata.flags.common) + ClassUtil.externalClassName(kotlinClassKindMetadata.className) + ")");
        if (kotlinClassKindMetadata.companionObjectName != null) {
            this.pw.print(" accompanied");
            if (!kotlinClassKindMetadata.companionObjectName.equals("Companion")) {
                this.pw.print(" by " + this.hasRefIndicator(kotlinClassKindMetadata.referencedCompanionClass) + kotlinClassKindMetadata.companionObjectName);
            }
        }
        if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
            this.pw.print(" from anonymous object class (" + ClassUtil.externalClassName(kotlinClassKindMetadata.anonymousObjectOriginName) + ")");
        }
        this.pw.println();
        this.indent();
        kotlinClassKindMetadata.typeParametersAccept(clazz, this);
        kotlinClassKindMetadata.superTypesAccept(clazz, this);
        kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, this);
        this.printArray("Nested classnames", kotlinClassKindMetadata.nestedClassNames, kotlinClassKindMetadata.referencedNestedClasses);
        this.printArray("Enum entry names", kotlinClassKindMetadata.enumEntryNames, kotlinClassKindMetadata.referencedEnumEntries);
        this.printArray("Sealed subclass names", kotlinClassKindMetadata.sealedSubclassNames, kotlinClassKindMetadata.referencedSealedSubClasses);
        kotlinClassKindMetadata.constructorsAccept(clazz, this);
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
        this.outdent();
    }

    @Override
    public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
        this.println("_____________________________________________________________________");
        this.println("Kotlin file facade: from Java class(" + ClassUtil.externalClassName(clazz.getName()) + ")");
        this.indent();
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
        this.outdent();
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        this.println("_____________________________________________________________________");
        this.println("Kotlin " + kotlinSyntheticClassKindMetadata.flavor.toString().toLowerCase() + " synthetic class(" + ClassUtil.externalClassName(clazz.getName()) + ") ");
        this.indent();
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
        this.outdent();
    }

    @Override
    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
        this.println("_____________________________________________________________________");
        this.println(this.hasRefIndicator(kotlinMultiFileFacadeKindMetadata.referencedPartClasses) + "Kotlin multi file facade (" + ClassUtil.externalClassName(clazz.getName()) + ")");
        this.indent();
        kotlinMultiFileFacadeKindMetadata.partClassNames.stream().map(ClassUtil::externalClassName).forEach(this::println);
        this.outdent();
    }

    @Override
    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        this.println("_____________________________________________________________________");
        this.println(this.hasRefIndicator(kotlinMultiFilePartKindMetadata.referencedFacadeClass) + "Kotlin multi file part metadata: " + ClassUtil.externalClassName(kotlinMultiFilePartKindMetadata.facadeName) + " from Java class(" + ClassUtil.externalClassName(clazz.getName()) + ")");
        this.indent();
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
        this.outdent();
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        this.print("[CTOR] ");
        if (kotlinClassKindMetadata.flags.isAnnotationClass) {
            this.pw.println(this.constructorFlags(kotlinConstructorMetadata.flags) + this.hasAnnotationsFlag(kotlinConstructorMetadata.flags.common));
        } else {
            this.pw.println(this.hasRefIndicator(kotlinConstructorMetadata.referencedMethod) + this.constructorFlags(kotlinConstructorMetadata.flags) + this.hasAnnotationsFlag(kotlinConstructorMetadata.flags.common) + "[" + KotlinMetadataPrinter.externalMethodDescription(kotlinConstructorMetadata.jvmSignature) + "]");
        }
        this.indent();
        kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, this);
        this.outdent();
    }

    @Override
    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        this.print("[TPRM] " + kotlinTypeParameterMetadata.id + ": ");
        if (!KotlinTypeVariance.INVARIANT.equals((Object)kotlinTypeParameterMetadata.variance)) {
            this.pw.print((Object)((Object)kotlinTypeParameterMetadata.variance) + " ");
        }
        this.pw.println(this.typeParameterFlags(kotlinTypeParameterMetadata.flags) + this.hasAnnotationsFlag(kotlinTypeParameterMetadata.flags.common) + kotlinTypeParameterMetadata.name);
        this.indent();
        kotlinTypeParameterMetadata.annotationsAccept(clazz, this);
        kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
        this.outdent();
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        this.println("[VALP] " + this.valueParameterFlags(kotlinValueParameterMetadata.flags) + this.hasAnnotationsFlag(kotlinValueParameterMetadata.flags.common) + "\"" + kotlinValueParameterMetadata.parameterName + "\" ");
    }

    @Override
    public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        this.visitAnyValueParameter(clazz, kotlinValueParameterMetadata);
        this.indent();
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
        this.outdent();
    }

    @Override
    public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        this.visitAnyValueParameter(clazz, kotlinValueParameterMetadata);
        this.indent();
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        this.outdent();
    }

    @Override
    public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        this.visitAnyValueParameter(clazz, kotlinValueParameterMetadata);
        this.indent();
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
        this.outdent();
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        this.print(this.propertyFlags(kotlinPropertyMetadata.flags) + this.hasAnnotationsFlag(kotlinPropertyMetadata.flags.common) + "\"" + kotlinPropertyMetadata.name + "\" ");
        String getString = kotlinPropertyMetadata.flags.hasGetter ? this.propertyAccessorFlags(kotlinPropertyMetadata.getterFlags) + this.hasAnnotationsFlag(kotlinPropertyMetadata.getterFlags.common) + "get" : "";
        String setString = kotlinPropertyMetadata.flags.hasSetter ? this.propertyAccessorFlags(kotlinPropertyMetadata.setterFlags) + this.hasAnnotationsFlag(kotlinPropertyMetadata.setterFlags.common) + "set" : "";
        this.pw.println("[" + getString + (kotlinPropertyMetadata.flags.hasGetter && kotlinPropertyMetadata.flags.hasSetter ? "/" : "") + setString + "] ");
        this.indent();
        if (kotlinPropertyMetadata.backingFieldSignature != null) {
            this.println("Backing field: " + this.hasRefIndicator(kotlinPropertyMetadata.referencedBackingField) + KotlinMetadataPrinter.externalFieldDescription(kotlinPropertyMetadata.backingFieldSignature));
        }
        if (kotlinPropertyMetadata.getterSignature != null) {
            this.println("Getter:        " + this.hasRefIndicator(kotlinPropertyMetadata.referencedGetterMethod) + KotlinMetadataPrinter.externalMethodDescription(kotlinPropertyMetadata.getterSignature));
        }
        if (kotlinPropertyMetadata.setterSignature != null) {
            this.println("Setter:        " + this.hasRefIndicator(kotlinPropertyMetadata.referencedSetterMethod) + KotlinMetadataPrinter.externalMethodDescription(kotlinPropertyMetadata.setterSignature));
        }
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
            String referencedSyntheticMethodClassNamePrefix = kotlinPropertyMetadata.referencedSyntheticMethodClass != null && clazz != kotlinPropertyMetadata.referencedSyntheticMethodClass ? ClassUtil.externalClassName(kotlinPropertyMetadata.referencedSyntheticMethodClass.getName()) + "." : "";
            this.println("Synthetic method for annotations: " + referencedSyntheticMethodClassNamePrefix + this.hasRefIndicator(kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations) + KotlinMetadataPrinter.externalMethodDescription(kotlinPropertyMetadata.syntheticMethodForAnnotations));
        }
        kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        this.outdent();
    }

    @Override
    public void visitProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        this.print("[PROP] ");
        this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
    }

    @Override
    public void visitDelegatedProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        this.print("[DPRP] ");
        this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[TYPE] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitAbbreviation(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata abbreviation) {
        this.print("[ABBR] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, abbreviation);
        this.outdent();
    }

    @Override
    public void visitOuterClass(Clazz clazz, KotlinTypeMetadata innerClass, KotlinTypeMetadata outerClass) {
        this.print("[OUTR] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, outerClass);
        this.outdent();
    }

    @Override
    public void visitTypeArgument(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata typeArgument) {
        this.print("[TARG] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, typeArgument);
        this.outdent();
    }

    @Override
    public void visitStarProjection(Clazz clazz, KotlinTypeMetadata typeWithStarArg) {
        this.println("[SARG] *");
    }

    @Override
    public void visitTypeUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeMetadata upperBound) {
        this.print("[UPPB] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, upperBound);
        this.outdent();
    }

    @Override
    public void visitSuperType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[SUPT] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitInlineClassUnderlyingPropertyType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[IUPT] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitFunctionReturnType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[RTRN] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitConstructorValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[VTYP] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitPropertyValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[VTYP] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitFunctionValParamVarArgType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[VTYP] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitAliasUnderlyingType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[UNDR] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitAliasExpandedType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[XPAN] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitPropertyReceiverType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[RECT] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
        this.print("[RECT] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, kotlinTypeMetadata);
        this.outdent();
    }

    @Override
    public void visitParameterUpperBound(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeMetadata upperBound) {
        this.print("[UPPB] ");
        this.indent();
        this.printKotlinTypeMetadata(clazz, upperBound);
        this.outdent();
    }

    @Override
    public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        this.println("[ALIA] " + this.hasAnnotationsFlag(kotlinTypeAliasMetadata.flags.common) + this.hasRefIndicator(kotlinTypeAliasMetadata.referencedDeclarationContainer) + kotlinTypeAliasMetadata.name + " ");
        this.indent();
        kotlinTypeAliasMetadata.annotationsAccept(clazz, this);
        kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        this.outdent();
    }

    @Override
    public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
        this.println("[VRSN] " + kotlinVersionRequirementMetadata.major + "." + kotlinVersionRequirementMetadata.minor + "." + kotlinVersionRequirementMetadata.patch + ", level: " + kotlinVersionRequirementMetadata.level.toString() + ", kind: " + kotlinVersionRequirementMetadata.kind.toString());
        this.indent();
        if (kotlinVersionRequirementMetadata.message != null) {
            this.println("Message: " + kotlinVersionRequirementMetadata.message);
        }
        if (kotlinVersionRequirementMetadata.errorCode != null) {
            this.println("Error code: " + kotlinVersionRequirementMetadata.errorCode);
        }
        this.outdent();
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        String referencedMethodClassNamePrefix = kotlinFunctionMetadata.referencedMethodClass != null && !clazz.equals(kotlinFunctionMetadata.referencedMethodClass) ? ClassUtil.externalClassName(kotlinFunctionMetadata.referencedMethodClass.getName()) + "." : "";
        this.pw.print(this.hasRefIndicator(kotlinFunctionMetadata.referencedMethod) + this.functionFlags(kotlinFunctionMetadata.flags) + this.hasAnnotationsFlag(kotlinFunctionMetadata.flags.common) + "\"" + kotlinFunctionMetadata.name + "\" [" + referencedMethodClassNamePrefix + KotlinMetadataPrinter.externalMethodDescription(kotlinFunctionMetadata.jvmSignature) + "] ");
        if (kotlinFunctionMetadata.referencedDefaultImplementationMethod != null) {
            this.pw.print("defaultImpl: [" + ClassUtil.externalClassName(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass.getName()) + "." + kotlinFunctionMetadata.referencedDefaultImplementationMethod.getName(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass) + "] ");
        }
        this.indent();
        this.println();
        kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinMetadata, this);
        if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
            this.println(this.hasRefIndicator(kotlinFunctionMetadata.referencedLambdaClassOrigin) + "Lambda class original name: " + ClassUtil.externalClassName(kotlinFunctionMetadata.lambdaClassOriginName));
        }
        this.outdent();
    }

    @Override
    public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        this.print("[FUNC] ");
        this.visitAnyFunction(clazz, kotlinDeclarationContainerMetadata, kotlinFunctionMetadata);
    }

    @Override
    public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        this.print("[SFUN] ");
        this.visitAnyFunction(clazz, kotlinSyntheticClassKindMetadata, kotlinFunctionMetadata);
    }

    @Override
    public void visitAnyAnnotation(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation) {
        this.println("[ANTN] " + this.hasRefIndicator(annotation.referencedAnnotationClass) + annotation);
    }

    @Override
    public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
        this.println("[CTRT] ");
        this.indent();
        kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, this);
        this.outdent();
    }

    @Override
    public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
        this.print("[EFFT] ");
        this.pw.print((Object)kotlinEffectMetadata.effectType);
        if (kotlinEffectMetadata.invocationKind != null) {
            this.pw.print(" " + (Object)((Object)kotlinEffectMetadata.invocationKind));
        }
        this.pw.println();
        this.indent();
        this.println("Constructor argument: ");
        this.indent();
        kotlinEffectMetadata.constructorArgumentAccept(clazz, this);
        this.outdent();
        this.println("Conclusion of conditional effect: ");
        this.indent();
        kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, this);
        this.outdent();
        this.outdent();
    }

    @Override
    public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
        boolean hasRightHandSides;
        boolean bl = hasRightHandSides = !kotlinEffectExpressionMetadata.orRightHandSides.isEmpty() || !kotlinEffectExpressionMetadata.andRightHandSides.isEmpty();
        if (hasRightHandSides) {
            this.println("(");
        }
        this.indent();
        this.print("");
        if (kotlinEffectExpressionMetadata.parameterIndex >= 0) {
            if (kotlinEffectExpressionMetadata.parameterIndex == 0) {
                this.pw.print("receiver param ");
            } else {
                this.pw.print("param " + (kotlinEffectExpressionMetadata.parameterIndex - 1) + " ");
            }
        }
        if (kotlinEffectExpressionMetadata.flags.isNegated) {
            this.pw.print("negated ");
        }
        if (kotlinEffectExpressionMetadata.flags.isNullCheckPredicate) {
            this.pw.print("nullCheckPredicate ");
        }
        if (kotlinEffectExpressionMetadata.hasConstantValue) {
            this.pw.print(" " + kotlinEffectExpressionMetadata.constantValue);
        }
        this.pw.println();
        kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, this);
        kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, this);
        kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, this);
        this.outdent();
        if (hasRightHandSides) {
            this.println(")");
        }
    }

    @Override
    public void visitAndRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
        this.println("AND");
        this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
    }

    @Override
    public void visitOrRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
        this.println("OR");
        this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
    }

    private void printKotlinTypeMetadata(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        if (kotlinTypeMetadata.className != null) {
            this.pw.print(this.hasRefIndicator(kotlinTypeMetadata.referencedClass));
        } else if (kotlinTypeMetadata.aliasName != null) {
            this.pw.print(this.hasRefIndicator(kotlinTypeMetadata.referencedTypeAlias));
        }
        this.pw.print(this.typeFlags(kotlinTypeMetadata.flags));
        if (kotlinTypeMetadata.isRaw) {
            this.pw.print("raw ");
        }
        if (kotlinTypeMetadata.variance != null && !kotlinTypeMetadata.variance.equals((Object)KotlinTypeVariance.INVARIANT)) {
            this.pw.print((Object)((Object)kotlinTypeMetadata.variance) + " ");
        }
        if (kotlinTypeMetadata.typeParamID >= 0) {
            this.pw.print("param " + kotlinTypeMetadata.typeParamID);
        } else {
            this.pw.print(this.hasAnnotationsFlag(kotlinTypeMetadata.flags.common));
            if (kotlinTypeMetadata.className != null) {
                this.pw.print(ClassUtil.externalClassName(kotlinTypeMetadata.className));
            } else if (kotlinTypeMetadata.aliasName != null) {
                this.pw.print("used as: " + ClassUtil.externalClassName(kotlinTypeMetadata.aliasName));
            }
        }
        if (kotlinTypeMetadata.flags.isNullable) {
            this.pw.print("?");
        }
        this.pw.print(" ");
        if (kotlinTypeMetadata.flexibilityID != null) {
            this.pw.print("(flexibilityID: " + kotlinTypeMetadata.flexibilityID + ") ");
        }
        this.pw.println();
        kotlinTypeMetadata.annotationsAccept(clazz, this);
        kotlinTypeMetadata.abbreviationAccept(clazz, this);
        kotlinTypeMetadata.upperBoundsAccept(clazz, this);
        kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
        kotlinTypeMetadata.outerClassAccept(clazz, this);
    }

    private void indent() {
        ++this.indentation;
    }

    private void outdent() {
        --this.indentation;
    }

    private void println(String string) {
        this.print(string);
        this.println();
    }

    private void print(String string) {
        for (int index = 0; index < this.indentation; ++index) {
            this.pw.print(INDENTATION);
        }
        this.pw.print(string);
    }

    private void println() {
        this.pw.println();
    }

    private void printArray(String prepend, List<String> names, List<?> objects) {
        if (names.size() > 0) {
            this.println(this.hasRefIndicator(objects) + prepend + ": " + String.join((CharSequence)", ", names));
        }
    }

    private String hasRefIndicator(Object arg) {
        return arg == null ? this.refMissingIndicator : "";
    }

    private String hasRefIndicator(Collection<?> objects) {
        if (objects == null) {
            return this.refMissingIndicator;
        }
        if (objects.isEmpty()) {
            return "";
        }
        int count = this.countNonNull(objects);
        if (objects.size() == count) {
            return "";
        }
        return this.refMissingIndicator + "(" + (objects.size() - count) + ") ";
    }

    private int countNonNull(Collection<?> arr) {
        int count = 0;
        for (Object o : arr) {
            if (o == null) continue;
            ++count;
        }
        return count;
    }

    private static String externalFieldDescription(FieldSignature jvmFieldSignature) {
        try {
            return ClassUtil.externalFullFieldDescription(0, jvmFieldSignature.memberName, jvmFieldSignature.descriptor);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            return "Invalid field descriptor: " + jvmFieldSignature;
        }
    }

    private static String externalMethodDescription(MethodSignature jvmMethodSignature) {
        try {
            return (ClassUtil.isInitializer(jvmMethodSignature.method) ? "" : jvmMethodSignature.descriptor.getPrettyReturnType() + ' ') + jvmMethodSignature.method + jvmMethodSignature.descriptor.getPrettyArgumentTypes();
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            return "Invalid method descriptor: " + jvmMethodSignature;
        }
    }

    private String modalityFlags(KotlinModalityFlags flags) {
        return (flags.isFinal ? "final " : "") + (flags.isOpen ? "open " : "") + (flags.isAbstract ? "abstract " : "") + (flags.isSealed ? "sealed " : "");
    }

    private String visibilityFlags(KotlinVisibilityFlags flags) {
        return (flags.isInternal ? "internal " : "") + (flags.isPrivate ? "private " : "") + (flags.isPublic ? "public " : "") + (flags.isProtected ? "protected " : "") + (flags.isPrivateToThis ? "privateToThis " : "") + (flags.isLocal ? "local " : "");
    }

    private String classFlags(KotlinClassFlags flags) {
        return this.visibilityFlags(flags.visibility) + this.modalityFlags(flags.modality) + (flags.isAnnotationClass ? "annotation " : "") + (flags.isUsualClass ? "usual " : "") + (flags.isObject ? "object " : "") + (flags.isData ? "data " : "") + (flags.isInline ? "inline " : "") + (flags.isValue ? "value " : "") + (flags.isInner ? "inner " : "") + (flags.isExpect ? "expect " : "") + (flags.isExternal ? "external " : "") + (flags.isCompanionObject ? "companion object " : "") + (flags.isEnumEntry ? "enum entry " : "") + (flags.isEnumClass ? "enum " : "") + (flags.isFun ? "fun interface " : (flags.isInterface ? "interface " : ""));
    }

    private String constructorFlags(KotlinConstructorFlags flags) {
        return this.visibilityFlags(flags.visibility) + (flags.isPrimary ? "primary " : "secondary ") + (flags.hasNonStableParameterNames ? "nonstable " : "stable ");
    }

    private String effectExpressionFlags(KotlinEffectExpressionFlags flags) {
        return (flags.isNegated ? "negated " : "") + (flags.isNullCheckPredicate ? "nullCheckPredicate " : "");
    }

    private String functionFlags(KotlinFunctionFlags flags) {
        return this.visibilityFlags(flags.visibility) + this.modalityFlags(flags.modality) + (flags.isDeclaration ? "fun " : "undeclared fun ") + (flags.isFakeOverride ? "fakeOverride " : "") + (flags.isDelegation ? "by " : "") + (flags.isSynthesized ? "synthetic " : "") + (flags.isOperator ? "operator " : "") + (flags.isInfix ? "infix " : "") + (flags.isInline ? "inline " : "") + (flags.isTailrec ? "tailrec " : "") + (flags.isExternal ? "external " : "") + (flags.isSuspend ? "suspend " : "") + (flags.isExpect ? "expect " : "");
    }

    private String propertyAccessorFlags(KotlinPropertyAccessorFlags flags) {
        return this.visibilityFlags(flags.visibility) + this.modalityFlags(flags.modality) + (flags.isDefault ? "" : "nonDefault ") + (flags.isExternal ? "external " : "") + (flags.isInline ? "inline " : "");
    }

    private String propertyFlags(KotlinPropertyFlags flags) {
        return this.visibilityFlags(flags.visibility) + this.modalityFlags(flags.modality) + (flags.isDeclared ? "" : "undeclared ") + (flags.isFakeOverride ? "fakeOverride " : "") + (flags.isDelegation ? "by " : "") + (flags.isSynthesized ? "synthetic " : "") + (flags.isVar ? "var " : "") + (flags.isConst ? "const " : "") + (flags.isLateinit ? "lateinit " : "") + (flags.hasConstant ? "hasConstant " : "") + (flags.isExternal ? "external " : "") + (flags.isDelegated ? "delegated " : "") + (flags.isExpect ? "expect " : "") + (flags.isMovedFromInterfaceCompanion ? "movedFromInterfaceCompanion " : "");
    }

    private String typeFlags(KotlinTypeFlags flags) {
        return flags.isSuspend ? "suspend " : "";
    }

    private String typeParameterFlags(KotlinTypeParameterFlags flags) {
        return flags.isReified ? "reified " : "";
    }

    private String valueParameterFlags(KotlinValueParameterFlags flags) {
        return (flags.isCrossInline ? "crossinline " : "") + (flags.isNoInline ? "noinline " : "") + (flags.hasDefaultValue ? "hasDefault " : "");
    }

    private String hasAnnotationsFlag(KotlinCommonFlags flags) {
        return flags.hasAnnotations ? "@" : "";
    }
}

