/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.CallVisitor;
import proguard.analysis.DominatorCalculator;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.CallGraph;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.analysis.datastructure.callgraph.SymbolicCall;
import proguard.backport.LambdaExpression;
import proguard.backport.LambdaExpressionCollector;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LineNumberFinder;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.ArrayReferenceValueFactory;
import proguard.evaluation.value.MultiTypedReferenceValue;
import proguard.evaluation.value.MultiTypedReferenceValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.util.PartialEvaluatorUtils;

public class CallResolver
implements AttributeVisitor,
ClassVisitor,
InstructionVisitor {
    private static final Logger log = LogManager.getLogger(CallResolver.class);
    private final Map<InvokeDynamicConstant, LambdaExpression> lambdaExpressionMap = new HashMap<InvokeDynamicConstant, LambdaExpression>();
    private final LambdaExpressionCollector lambdaExpressionCollector = new LambdaExpressionCollector(this.lambdaExpressionMap);
    private final DominatorCalculator dominatorCalculator;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CallGraph callGraph;
    private final boolean clearCallValuesAfterVisit;
    private final boolean useDominatorAnalysis;
    private final List<CallVisitor> visitors;
    private final PartialEvaluator particularValueEvaluator;
    private boolean particularValueEvaluationSuccessful;
    private final PartialEvaluator multiTypeValueEvaluator;
    private boolean multiTypeEvaluationSuccessful;

    public CallResolver(ClassPool programClassPool, ClassPool libraryClassPool, CallGraph callGraph, boolean clearCallValuesAfterVisit, boolean useDominatorAnalysis, boolean evaluateAllCode, boolean includeSubClasses, int maxPartialEvaluations, CallVisitor ... visitors) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.callGraph = callGraph;
        this.clearCallValuesAfterVisit = clearCallValuesAfterVisit;
        this.useDominatorAnalysis = useDominatorAnalysis;
        this.visitors = Arrays.asList(visitors);
        this.dominatorCalculator = new DominatorCalculator();
        MultiTypedReferenceValueFactory multiTypeValueFactory = includeSubClasses ? new MultiTypedReferenceValueFactory(true, this.programClassPool, this.libraryClassPool) : new MultiTypedReferenceValueFactory();
        BasicInvocationUnit multiTypeValueInvocationUnit = new BasicInvocationUnit(multiTypeValueFactory);
        this.multiTypeValueEvaluator = PartialEvaluator.Builder.create().setValueFactory(multiTypeValueFactory).setInvocationUnit(multiTypeValueInvocationUnit).setEvaluateAllCode(evaluateAllCode).stopAnalysisAfterNEvaluations(maxPartialEvaluations).build();
        ParticularValueFactory particularValueFactory = new ParticularValueFactory(new ArrayReferenceValueFactory(), new ParticularValueFactory.ReferenceValueFactory());
        ExecutingInvocationUnit particularValueInvocationUnit = new ExecutingInvocationUnit(particularValueFactory);
        this.particularValueEvaluator = PartialEvaluator.Builder.create().setValueFactory(particularValueFactory).setInvocationUnit(particularValueInvocationUnit).setEvaluateAllCode(evaluateAllCode).stopAnalysisAfterNEvaluations(maxPartialEvaluations).build();
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.lambdaExpressionMap.clear();
        programClass.accept(new MultiClassVisitor(this.lambdaExpressionCollector, new AllAttributeVisitor(true, this)));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.multiTypeEvaluationSuccessful = false;
            this.multiTypeValueEvaluator.visitCodeAttribute0(clazz, method, codeAttribute);
            this.multiTypeEvaluationSuccessful = true;
        }
        catch (Exception e) {
            Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_EXCEPTION);
            log.debug("Exception during evaluating types", (Throwable)e);
        }
        try {
            this.particularValueEvaluationSuccessful = false;
            this.particularValueEvaluator.visitCodeAttribute0(clazz, method, codeAttribute);
            this.particularValueEvaluationSuccessful = true;
        }
        catch (Exception e) {
            Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_EXCEPTION);
            log.debug("Exception during evaluating values", (Throwable)e);
        }
        if (this.useDominatorAnalysis) {
            this.dominatorCalculator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        LineNumberFinder lineNumberFinder = new LineNumberFinder(offset);
        codeAttribute.attributesAccept(clazz, method, lineNumberFinder);
        CodeLocation location = new CodeLocation(clazz, method, offset, lineNumberFinder.lineNumber);
        Constant constant = ((ProgramClass)clazz).getConstant(constantInstruction.constantIndex);
        if (constantInstruction.opcode == -70 && constant instanceof InvokeDynamicConstant) {
            this.handleInvokeDynamic(location, (InvokeDynamicConstant)constant);
        } else if (constant instanceof AnyMethodrefConstant) {
            AnyMethodrefConstant ref = (AnyMethodrefConstant)constant;
            switch (constantInstruction.opcode) {
                case -72: {
                    this.handleInvokeStatic(location, (AnyMethodrefConstant)constant);
                    break;
                }
                case -74: 
                case -71: {
                    this.handleVirtualMethods(location, ref, constantInstruction.opcode);
                    break;
                }
                case -73: {
                    this.handleInvokeSpecial(location, ref);
                    break;
                }
                default: {
                    Metrics.increaseCount(Metrics.MetricType.UNSUPPORTED_OPCODE);
                    log.warn("Unsupported invocation opcode " + constantInstruction.opcode + " at " + location);
                }
            }
        }
    }

    private void addCall(CodeLocation location, String targetClass, String targetMethod, String targetDescriptor, int throwsNullptr, byte invocationOpcode, boolean runtimeTypeDependent) {
        boolean alwaysInvoked = true;
        if (this.useDominatorAnalysis) {
            alwaysInvoked = this.dominatorCalculator.dominates(location.offset, -1);
        }
        Call call = this.instantiateCall(location, targetClass, targetMethod, targetDescriptor, throwsNullptr, invocationOpcode, !alwaysInvoked, runtimeTypeDependent);
        this.initArgumentsAndReturnValue(call);
        this.visitors.forEach(d -> d.visitCall(call));
        if (this.clearCallValuesAfterVisit) {
            call.clearValues();
        }
        if (this.callGraph != null) {
            this.callGraph.addCall(call);
        }
    }

    private Call instantiateCall(CodeLocation location, String targetClass, String targetMethod, String targetDescriptor, int throwsNullptr, byte invocationOpcode, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        Call call;
        Clazz containingClass = this.programClassPool.getClass(targetClass);
        if (containingClass == null) {
            containingClass = this.libraryClassPool.getClass(targetClass);
        }
        if (containingClass == null) {
            call = new SymbolicCall(location, new MethodSignature(targetClass, targetMethod, targetDescriptor), throwsNullptr, invocationOpcode, controlFlowDependent, runtimeTypeDependent);
            Metrics.increaseCount(Metrics.MetricType.SYMBOLIC_CALL);
        } else {
            Method method = containingClass.findMethod(targetMethod, targetDescriptor);
            if (method == null) {
                call = new SymbolicCall(location, new MethodSignature(targetClass, targetMethod, targetDescriptor), throwsNullptr, invocationOpcode, controlFlowDependent, runtimeTypeDependent);
                Metrics.increaseCount(Metrics.MetricType.SYMBOLIC_CALL);
            } else {
                call = new ConcreteCall(location, containingClass, method, throwsNullptr, invocationOpcode, controlFlowDependent, runtimeTypeDependent);
                Metrics.increaseCount(Metrics.MetricType.CONCRETE_CALL);
                if ((method.getAccessFlags() & 0x400) != 0) {
                    Metrics.increaseCount(Metrics.MetricType.CALL_TO_ABSTRACT_METHOD);
                }
            }
        }
        return call;
    }

    private void initArgumentsAndReturnValue(Call call) {
        boolean isStaticCall = call.invocationOpcode == -72 || call.invocationOpcode == -70;
        MethodSignature target = call.getTarget();
        List<Value> arguments = this.getArguments(call.caller, target, isStaticCall);
        if (!isStaticCall && !arguments.isEmpty()) {
            call.setInstance(arguments.remove(0));
        }
        call.setArguments(arguments);
        if (!target.descriptor.getPrettyReturnType().equals("void") && this.particularValueEvaluationSuccessful) {
            call.setReturnValue(PartialEvaluatorUtils.getStackValue(this.particularValueEvaluator.getStackAfter(call.caller.offset), 0));
        }
    }

    private List<Value> getArguments(CodeLocation location, MethodSignature invokedMethodSig, boolean isStaticCall) {
        if (!this.multiTypeEvaluationSuccessful || !this.particularValueEvaluationSuccessful) {
            return Collections.emptyList();
        }
        if (invokedMethodSig.descriptor.argumentTypes == null) {
            log.error("Argument types list of {} is null!", (Object)invokedMethodSig);
            return Collections.emptyList();
        }
        ArrayList<Value> args = new ArrayList<Value>();
        int stackOffset = 0;
        for (int argNumber = invokedMethodSig.descriptor.argumentTypes.size() - 1; argNumber >= 0; --argNumber) {
            String argType = invokedMethodSig.descriptor.argumentTypes.get(argNumber);
            Value stackTop = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, stackOffset);
            if (!(stackTop instanceof MultiTypedReferenceValue) || ((MultiTypedReferenceValue)stackTop).getPotentialTypes().size() <= 1) {
                stackTop = PartialEvaluatorUtils.getStackBefore(this.particularValueEvaluator, location.offset, stackOffset);
            }
            args.add(0, stackTop);
            stackOffset += ClassUtil.internalTypeSize(argType);
        }
        if (!isStaticCall) {
            Value instance = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, stackOffset);
            if (!(instance instanceof MultiTypedReferenceValue) || ((MultiTypedReferenceValue)instance).getPotentialTypes().size() <= 1) {
                instance = PartialEvaluatorUtils.getStackBefore(this.particularValueEvaluator, location.offset, stackOffset);
            }
            args.add(0, instance);
        }
        return args;
    }

    private void handleInvokeDynamic(CodeLocation location, InvokeDynamicConstant constant) {
        if (this.lambdaExpressionMap.containsKey(constant)) {
            LambdaExpression target = this.lambdaExpressionMap.get(constant);
            this.addCall(location, target.invokedClassName, target.invokedMethodName, target.invokedMethodDesc, -1, (byte)-70, false);
        } else {
            log.debug("invokedynamic without matching lambda expression at {}", (Object)location);
        }
    }

    private void handleInvokeStatic(CodeLocation location, AnyMethodrefConstant constant) {
        this.addCall(location, constant.getClassName(location.clazz), constant.getName(location.clazz), constant.getType(location.clazz), -1, (byte)-72, false);
    }

    private void handleInvokeSpecial(CodeLocation location, AnyMethodrefConstant ref) {
        Set<String> targets = this.resolveInvokeSpecial(location.clazz, ref);
        if (targets.isEmpty()) {
            Metrics.increaseCount(Metrics.MetricType.MISSING_METHODS);
            log.debug("Missing method {}", (Object)ref.getClassName(location.clazz));
        } else {
            String name = ref.getName(location.clazz);
            String descriptor = ref.getType(location.clazz);
            for (String target : targets) {
                this.addCall(location, target, name, descriptor, -1, (byte)-73, false);
            }
        }
    }

    private Set<String> resolveInvokeSpecial(Clazz callingClass, AnyMethodrefConstant ref) {
        String name = ref.getName(callingClass);
        String descriptor = ref.getType(callingClass);
        Clazz c = (callingClass.getAccessFlags() & 0x20) != 0 && !name.equals("<init>") && ref.referencedClass != null && (ref.referencedClass.getAccessFlags() & 0x200) == 0 && callingClass.extends_(ref.referencedClass) && !callingClass.getName().equals(ref.referencedClass.getName()) ? callingClass.getSuperClass() : ref.referencedClass;
        if (c == null) {
            String className = ref.getClassName(callingClass);
            Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
            log.debug("Missing class {}", (Object)className);
            return Collections.singleton(className);
        }
        if (c.findMethod(name, descriptor) != null) {
            return Collections.singleton(c.getName());
        }
        Optional<Object> target = Optional.empty();
        if ((c.getAccessFlags() & 0x200) == 0) {
            target = this.resolveFromSuperclasses(c, name, descriptor);
        } else {
            for (java.lang.reflect.Method m : Object.class.getMethods()) {
                if ((m.getModifiers() & 1) == 0 || !m.getName().equals(name) || !CallResolver.getDescriptor(m).equals(descriptor)) continue;
                target = Optional.of("java/lang/Object");
                break;
            }
        }
        return target.map(Collections::singleton).orElseGet(() -> this.resolveFromSuperinterfaces(c, name, descriptor));
    }

    public static String getDescriptor(java.lang.reflect.Method m) {
        List parameters = Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.toList());
        return ClassUtil.internalMethodDescriptor(m.getReturnType().getName(), parameters);
    }

    private void handleVirtualMethods(CodeLocation location, AnyMethodrefConstant ref, byte invocationOpcode) {
        String name = ref.getName(location.clazz);
        String descriptor = ref.getType(location.clazz);
        int argumentCount = ClassUtil.internalMethodParameterSize(descriptor, false);
        Value thisPtr = PartialEvaluatorUtils.getStackBefore(this.multiTypeValueEvaluator, location.offset, argumentCount - 1);
        if (!(thisPtr instanceof MultiTypedReferenceValue)) {
            if (this.multiTypeEvaluationSuccessful) {
                String classInfo = thisPtr == null ? "null" : thisPtr.getClass().toString();
                Metrics.increaseCount(Metrics.MetricType.PARTIAL_EVALUATOR_VALUE_IMPRECISE);
                log.debug("Virtual call at {}: this-pointer is not a multi typed reference value but {}", (Object)location, (Object)classInfo);
            }
        } else {
            MultiTypedReferenceValue multiTypeThisPtr = (MultiTypedReferenceValue)thisPtr;
            for (TypedReferenceValue possibleType : multiTypeThisPtr.getPotentialTypes()) {
                Set<String> targetClasses;
                Clazz referencedClass;
                if (possibleType.isNull() == 1) {
                    this.addCall(location, ref.getClassName(location.clazz), ref.getName(location.clazz), ref.getType(location.clazz), 1, invocationOpcode, multiTypeThisPtr.getPotentialTypes().size() > 1);
                    continue;
                }
                if (ClassUtil.isInternalArrayType(possibleType.getType())) {
                    referencedClass = this.libraryClassPool.getClass("java/lang/Object");
                } else {
                    referencedClass = possibleType.getReferencedClass();
                    if (referencedClass == null) {
                        referencedClass = this.programClassPool.getClass(possibleType.getType());
                    }
                    if (referencedClass == null) {
                        referencedClass = this.libraryClassPool.getClass(possibleType.getType());
                    }
                }
                if (referencedClass == null) {
                    Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
                    log.info("Missing class {}", (Object)possibleType.getType());
                }
                if ((targetClasses = this.resolveVirtual(location.clazz, referencedClass, ref)).isEmpty()) {
                    if (referencedClass != null) {
                        Metrics.increaseCount(Metrics.MetricType.MISSING_METHODS);
                        log.debug("Missing method {}", (Object)ref.getClassName(location.clazz));
                    }
                    targetClasses = Collections.singleton(possibleType.getType());
                }
                for (String targetClass : targetClasses) {
                    this.addCall(location, targetClass, name, descriptor, multiTypeThisPtr.isNull(), invocationOpcode, multiTypeThisPtr.getPotentialTypes().size() > 1);
                }
            }
        }
    }

    private Set<String> resolveVirtual(Clazz callingClass, Clazz thisPtrType, AnyMethodrefConstant ref) {
        if (thisPtrType == null) {
            return Collections.emptySet();
        }
        String name = ref.getName(callingClass);
        String descriptor = ref.getType(callingClass);
        return this.resolveFromSuperclasses(thisPtrType, name, descriptor).map(Collections::singleton).orElseGet(() -> this.resolveFromSuperinterfaces(thisPtrType, name, descriptor));
    }

    private Optional<String> resolveFromSuperclasses(Clazz start, String name, String descriptor) {
        for (Clazz curr = start; curr != null; curr = curr.getSuperClass()) {
            Method targetMethod = curr.findMethod(name, descriptor);
            if (targetMethod == null || (targetMethod.getAccessFlags() & 0x400) != 0) continue;
            return Optional.of(curr.getName());
        }
        return Optional.empty();
    }

    private Set<String> resolveFromSuperinterfaces(Clazz start, String name, String descriptor) {
        HashSet<Clazz> superInterfaces = new HashSet<Clazz>();
        this.getSuperinterfaces(start, superInterfaces);
        Set applicableInterfaces = superInterfaces.stream().filter(i -> {
            Method m = i.findMethod(name, descriptor);
            return m != null && (m.getAccessFlags() & 0x40A) == 0;
        }).collect(Collectors.toSet());
        for (Clazz iface : new HashSet(applicableInterfaces)) {
            superInterfaces.clear();
            this.getSuperinterfaces(iface, superInterfaces);
            superInterfaces.forEach(applicableInterfaces::remove);
        }
        return applicableInterfaces.stream().map(Clazz::getName).collect(Collectors.toSet());
    }

    private void getSuperinterfaces(Clazz start, Set<Clazz> accumulator) {
        for (int i = 0; i < start.getInterfaceCount(); ++i) {
            Clazz iface = start.getInterface(i);
            if (iface == null) {
                Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
                log.info("Missing class {}", (Object)start.getName());
                continue;
            }
            accumulator.add(iface);
            this.getSuperinterfaces(iface, accumulator);
        }
        if (start.getSuperClass() != null) {
            this.getSuperinterfaces(start.getSuperClass(), accumulator);
        }
    }

    public static class Metrics {
        public static final Map<MetricType, Integer> counts = new TreeMap<MetricType, Integer>();

        public static void increaseCount(MetricType type) {
            counts.merge(type, 1, Integer::sum);
        }

        public static String flush() {
            StringBuilder result = new StringBuilder("Call resolver Metrics:\n");
            counts.forEach((type, count) -> result.append(type.name()).append(": ").append(count).append("\n"));
            counts.clear();
            return result.toString();
        }

        public static enum MetricType {
            MISSING_CLASS,
            MISSING_METHODS,
            UNSUPPORTED_OPCODE,
            PARTIAL_EVALUATOR_EXCEPTION,
            PARTIAL_EVALUATOR_VALUE_IMPRECISE,
            SYMBOLIC_CALL,
            CONCRETE_CALL,
            CALL_TO_ABSTRACT_METHOD;

        }
    }

    public static class Builder {
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;
        private final CallGraph callGraph;
        private final CallVisitor[] visitors;
        private boolean clearCallValuesAfterVisit = true;
        private boolean useDominatorAnalysis = false;
        private boolean evaluateAllCode = false;
        private boolean includeSubClasses = false;
        private int maxPartialEvaluations = 50;

        public Builder(ClassPool programClassPool, ClassPool libraryClassPool, CallGraph callGraph, CallVisitor ... visitors) {
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
            this.callGraph = callGraph;
            this.visitors = visitors;
        }

        public Builder setClearCallValuesAfterVisit(boolean clearCallValuesAfterVisit) {
            this.clearCallValuesAfterVisit = clearCallValuesAfterVisit;
            return this;
        }

        public Builder setUseDominatorAnalysis(boolean useDominatorAnalysis) {
            this.useDominatorAnalysis = useDominatorAnalysis;
            return this;
        }

        public Builder setEvaluateAllCode(boolean evaluateAllCode) {
            this.evaluateAllCode = evaluateAllCode;
            return this;
        }

        public Builder setIncludeSubClasses(boolean includeSubClasses) {
            this.includeSubClasses = includeSubClasses;
            return this;
        }

        public Builder setMaxPartialEvaluations(int maxPartialEvaluations) {
            this.maxPartialEvaluations = maxPartialEvaluations;
            return this;
        }

        public CallResolver build() {
            return new CallResolver(this.programClassPool, this.libraryClassPool, this.callGraph, this.clearCallValuesAfterVisit, this.useDominatorAnalysis, this.evaluateAllCode, this.includeSubClasses, this.maxPartialEvaluations, this.visitors);
        }
    }
}

