/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.SimpleClassPrinter;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;
import proguard.pass.Pass;
import proguard.util.PrintWriterUtil;

public class SeedPrinter
implements Pass {
    private static final Logger logger = LogManager.getLogger(SeedPrinter.class);
    private final Configuration configuration;

    public SeedPrinter(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Printing kept classes, fields, and methods...");
        PrintWriter printWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printSeeds);
        try {
            if (this.configuration.keep == null) {
                throw new IOException("You have to specify '-keep' options if you want to write out kept elements with '-printseeds'.");
            }
            appView.programClassPool.classesAccept((ClassVisitor)new ClassCleaner());
            appView.libraryClassPool.classesAccept((ClassVisitor)new ClassCleaner());
            KeepMarker keepMarker = new KeepMarker();
            ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(true, true, true).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, null);
            appView.programClassPool.accept(classPoolvisitor);
            appView.libraryClassPool.accept(classPoolvisitor);
            SimpleClassPrinter printer = new SimpleClassPrinter(false, printWriter);
            appView.programClassPool.classesAcceptAlphabetically((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new KeptClassFilter((ClassVisitor)printer), new AllMemberVisitor((MemberVisitor)new KeptMemberFilter((MemberVisitor)printer))}));
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printSeeds, printWriter);
        }
    }
}

