/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassPool;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class TimedClassPoolVisitor
implements ClassPoolVisitor {
    private static final boolean DETAILS = System.getProperty("tcpv") != null;
    private final String message;
    private final ClassPoolVisitor classPoolVisitor;

    public TimedClassPoolVisitor(String message, ClassVisitor classVisitor) {
        this(message, (ClassPoolVisitor)new AllClassVisitor(classVisitor));
    }

    public TimedClassPoolVisitor(String message, ClassPoolVisitor classPoolVisitor) {
        this.message = message;
        this.classPoolVisitor = classPoolVisitor;
    }

    public void visitClassPool(ClassPool classPool) {
        long start = 0L;
        if (DETAILS) {
            System.out.print(this.message);
            System.out.print(this.getPadding(this.message.length(), 48));
            start = System.currentTimeMillis();
        }
        classPool.accept(this.classPoolVisitor);
        if (DETAILS) {
            long end = System.currentTimeMillis();
            System.out.printf(" took: %6d ms%n", end - start);
        }
    }

    private String getPadding(int pos, int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = pos; i < size; ++i) {
            sb.append('.');
        }
        return sb.toString();
    }
}

