/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class MemberReferenceGeneralizer
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    private static final boolean DEBUG = System.getProperty("mrg") != null;
    private final boolean fieldGeneralizationClass;
    private final boolean methodGeneralizationClass;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraFieldInstructionVisitor;
    private final InstructionVisitor extraMethodInstructionVisitor;
    private int invocationOffset;
    private byte invocationOpcode;
    private String memberName;
    private String memberType;
    private Clazz generalizedClass;
    private Member generalizedMember;

    public MemberReferenceGeneralizer(boolean fieldGeneralizationClass, boolean methodGeneralizationClass, CodeAttributeEditor codeAttributeEditor) {
        this(fieldGeneralizationClass, methodGeneralizationClass, codeAttributeEditor, null, null);
    }

    public MemberReferenceGeneralizer(boolean fieldGeneralizationClass, boolean methodGeneralizationClass, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraFieldInstructionVisitor, InstructionVisitor extraMethodInstructionVisitor) {
        this.fieldGeneralizationClass = fieldGeneralizationClass;
        this.methodGeneralizationClass = methodGeneralizationClass;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraFieldInstructionVisitor = extraFieldInstructionVisitor;
        this.extraMethodInstructionVisitor = extraMethodInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        switch (opcode) {
            case -76: 
            case -75: {
                if (!this.fieldGeneralizationClass || this.codeAttributeEditor.isModified(offset)) break;
                this.invocationOffset = offset;
                this.invocationOpcode = opcode;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (this.generalizedClass == null || this.extraFieldInstructionVisitor == null) break;
                this.extraFieldInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                break;
            }
            case -74: {
                if (!this.methodGeneralizationClass || this.codeAttributeEditor.isModified(offset)) break;
                this.invocationOffset = offset;
                this.invocationOpcode = opcode;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (this.generalizedClass == null || this.extraMethodInstructionVisitor == null) break;
                this.extraMethodInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Field referencedMember;
        this.memberName = refConstant.getName(clazz);
        this.memberType = refConstant.getType(clazz);
        this.generalizedClass = null;
        this.generalizedMember = null;
        Object object = referencedMember = refConstant instanceof FieldrefConstant ? ((FieldrefConstant)refConstant).referencedField : ((AnyMethodrefConstant)refConstant).referencedMethod;
        if (referencedMember != null && (referencedMember.getProcessingFlags() & 1) != 0) {
            clazz.constantPoolEntryAccept(refConstant.u2classIndex, (ConstantVisitor)this);
            if (this.generalizedClass != null && !this.generalizedClass.getName().equals(refConstant.getClassName(clazz))) {
                int refConstantIndex;
                if (DEBUG) {
                    System.out.println("ReferenceGeneralizer: [" + clazz.getName() + "] invocation [" + refConstant.getClassName(clazz) + "." + this.memberName + this.memberType + "] -> [" + this.generalizedClass.getName() + ". ...]");
                }
                Clazz clazz2 = clazz;
                synchronized (clazz2) {
                    ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                    int generalizedClassConstantIndex = constantPoolEditor.addClassConstant(this.generalizedClass);
                    refConstantIndex = this.invocationOpcode != -74 ? constantPoolEditor.addFieldrefConstant(generalizedClassConstantIndex, this.memberName, this.memberType, this.generalizedClass, (Field)this.generalizedMember) : constantPoolEditor.addMethodrefConstant(generalizedClassConstantIndex, this.memberName, this.memberType, this.generalizedClass, (Method)this.generalizedMember);
                }
                ConstantInstruction replacementInstruction = new ConstantInstruction(this.invocationOpcode, refConstantIndex);
                this.codeAttributeEditor.replaceInstruction(this.invocationOffset, (Instruction)replacementInstruction);
            } else {
                this.generalizedClass = null;
            }
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void visitAnyClass(Clazz clazz) {
        if (this.invocationOpcode == -74) {
            Clazz superClass = clazz.getSuperClass();
            if (superClass != null) {
                Method method;
                superClass.accept((ClassVisitor)this);
                if (this.generalizedClass == null && (superClass.getAccessFlags() & 1) != 0 && (method = superClass.findMethod(this.memberName, this.memberType)) != null && (method.getAccessFlags() & 1) != 0 && (method.getProcessingFlags() & 1) != 0) {
                    this.generalizedClass = superClass;
                    this.generalizedMember = method;
                }
            }
        } else {
            Field field = clazz.findField(this.memberName, this.memberType);
            if (field != null && (field.getProcessingFlags() & 1) != 0) {
                this.generalizedClass = clazz;
                this.generalizedMember = field;
            } else {
                Clazz superClass = clazz.getSuperClass();
                if (superClass != null) {
                    superClass.accept((ClassVisitor)this);
                }
            }
        }
    }
}

