/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.visitor.KotlinFunctionToMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinFunctionFilter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;

public class KotlinDataClassObfuscator
implements KotlinMetadataVisitor {
    private static final Comparator<String> REVERSE_LENGTH_STRING_ORDER = Comparator.comparingInt(String::length).reversed().thenComparing(Function.identity());

    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        TreeMap<String, String> nameMap = new TreeMap<String, String>(REVERSE_LENGTH_STRING_ORDER);
        kotlinClassKindMetadata.propertiesAccept(clazz, (KotlinPropertyVisitor)new PropertyNameCollector(nameMap));
        if (!ClassObfuscator.hasOriginalClassName(clazz)) {
            nameMap.put(ClassUtil.internalSimpleClassName((String)kotlinClassKindMetadata.className) + "(", ClassUtil.internalSimpleClassName((String)ClassObfuscator.newClassName(clazz)) + "(");
        }
        kotlinClassKindMetadata.functionsAccept(clazz, (KotlinFunctionVisitor)new KotlinFunctionFilter(fun -> !fun.flags.isDeclaration && fun.name.equals("toString") && fun.jvmSignature.getDesc().equals("()Ljava/lang/String;"), (KotlinFunctionVisitor)new KotlinFunctionToMethodVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new MyObfuscatedToStringFixer(nameMap, new ConstantPoolEditor((ProgramClass)clazz))))));
    }

    private static final class PropertyNameCollector
    implements KotlinPropertyVisitor {
        private final Map<String, String> nameMap;

        private PropertyNameCollector(Map<String, String> nameMap) {
            this.nameMap = nameMap;
        }

        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            if (kotlinPropertyMetadata.getProcessingInfo() != null) {
                this.nameMap.put(kotlinPropertyMetadata.name + "=", kotlinPropertyMetadata.getProcessingInfo() + "=");
            }
        }
    }

    private static final class MyObfuscatedToStringFixer
    implements AttributeVisitor,
    InstructionVisitor,
    ConstantVisitor {
        private final Map<String, String> originalToNewName;
        private final ConstantPoolEditor constantPoolEditor;
        private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        private String replacement = null;

        private MyObfuscatedToStringFixer(Map<String, String> originalToNewName, ConstantPoolEditor constantPoolEditor) {
            this.originalToNewName = originalToNewName;
            this.constantPoolEditor = constantPoolEditor;
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
            codeAttribute.accept(clazz, method, (AttributeVisitor)this.codeAttributeEditor);
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == 18 || constantInstruction.opcode == 19) {
                this.replacement = null;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (this.replacement != null) {
                    constantInstruction.constantIndex = this.constantPoolEditor.addStringConstant(this.replacement);
                    this.codeAttributeEditor.replaceInstruction(offset, (Instruction)constantInstruction);
                }
            }
        }

        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            clazz.constantPoolEntryAccept(stringConstant.u2stringIndex, (ConstantVisitor)this);
        }

        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            TreeMap<String, String> copy = new TreeMap<String, String>(this.originalToNewName);
            boolean foundAny = false;
            this.replacement = utf8Constant.getString();
            for (String originalName : copy.keySet()) {
                if (!this.replacement.contains(originalName)) continue;
                this.replacement = this.replacement.replace(originalName, (CharSequence)copy.get(originalName));
                foundAny = true;
                this.originalToNewName.remove(originalName);
            }
            if (!foundAny) {
                this.replacement = null;
            }
        }

        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }
    }
}

