/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.constraint.AbstractKotlinMetadataConstraint;

public class ClassIntegrity
extends AbstractKotlinMetadataConstraint {
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        AssertUtil util = new AssertUtil("Class " + kotlinClassKindMetadata.className, this.reporter);
        util.reportIfNullReference("referenced class", kotlinClassKindMetadata.referencedClass);
        if (kotlinClassKindMetadata.referencedModule != null) {
            this.reporter.report("Unexpected module reference on class kind: " + kotlinClassKindMetadata.referencedModule.name);
        }
        if (kotlinClassKindMetadata.companionObjectName != null) {
            String referencedCompanionFieldName;
            util.reportIfNullReference("companion", kotlinClassKindMetadata.referencedCompanionClass);
            util.reportIfNullReference("companion field", kotlinClassKindMetadata.referencedCompanionField);
            String referencedCompanionClassName = kotlinClassKindMetadata.referencedCompanionClass.getName();
            if (!referencedCompanionClassName.contains("$")) {
                this.reporter.report("Companion for " + clazz.getName() + " should have $ in the name, found " + referencedCompanionClassName);
            }
            if (!(referencedCompanionFieldName = kotlinClassKindMetadata.referencedCompanionField.getName(clazz)).equals(referencedCompanionClassName.substring(referencedCompanionClassName.lastIndexOf("$") + 1))) {
                this.reporter.report("Companion field should have same name as companion class: " + kotlinClassKindMetadata.referencedCompanionField.getName(clazz) + " (in " + clazz.getName() + " ) != " + ClassUtil.internalSimpleClassName((String)referencedCompanionClassName));
            }
            kotlinClassKindMetadata.companionAccept((KotlinMetadataVisitor)new MyCompanionObjectFlagChecker());
        }
        if (kotlinClassKindMetadata.superTypes.isEmpty()) {
            this.reporter.report("Kotlin class " + kotlinClassKindMetadata.className + " has no super types");
        }
        kotlinClassKindMetadata.referencedEnumEntries.forEach(enumEntry -> util.reportIfFieldDangling("enum entries", clazz, (Field)enumEntry));
        kotlinClassKindMetadata.referencedNestedClasses.forEach(nestedClass -> util.reportIfNullReference("nested classes", nestedClass));
        kotlinClassKindMetadata.referencedSealedSubClasses.forEach(sealedSubClass -> util.reportIfNullReference("sealed subclasses", sealedSubClass));
        if (kotlinClassKindMetadata.flags.isObject && kotlinClassKindMetadata.referencedClass != null && kotlinClassKindMetadata.referencedClass.findField("INSTANCE", null) == null) {
            this.reporter.report("Object class should have a field named INSTANCE");
        }
    }

    private class MyCompanionObjectFlagChecker
    implements KotlinMetadataVisitor {
        private MyCompanionObjectFlagChecker() {
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            if (!kotlinClassKindMetadata.flags.isCompanionObject) {
                ClassIntegrity.this.reporter.report("Companion class '" + clazz.getName() + "' flag isCompanionObject should be true");
            }
            kotlinClassKindMetadata.referencedClass.accept((ClassVisitor)new MyInnerClassChecker());
        }
    }

    private class MyInnerClassChecker
    implements ClassVisitor,
    AttributeVisitor {
        private boolean hasInnerClassesAttribute;

        private MyInnerClassChecker() {
        }

        public void visitAnyClass(Clazz clazz) {
        }

        public void visitProgramClass(ProgramClass programClass) {
            this.hasInnerClassesAttribute = false;
            programClass.attributeAccept("InnerClasses", (AttributeVisitor)this);
            if (!this.hasInnerClassesAttribute) {
                ClassIntegrity.this.reporter.report("Missing inner classes attribute for " + programClass.getName());
            }
        }

        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            this.hasInnerClassesAttribute = true;
        }
    }
}

