/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class WrapperClassUseSimplifier
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private Clazz wrappedClass;
    private Instruction popInstruction;

    public WrapperClassUseSimplifier() {
        this(null);
    }

    public WrapperClassUseSimplifier(InstructionVisitor extraInstructionVisitor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                int nextOffset = offset + constantInstruction.length(offset);
                this.popInstruction = InstructionFactory.create((byte[])codeAttribute.code, (int)nextOffset);
                switch (this.popInstruction.canonicalOpcode()) {
                    case 89: {
                        this.codeAttributeEditor.deleteInstruction(offset);
                        this.codeAttributeEditor.deleteInstruction(nextOffset);
                        this.popInstruction = null;
                        break;
                    }
                    case 58: {
                        this.codeAttributeEditor.replaceInstruction(offset, (Instruction)new SimpleInstruction(1));
                        break;
                    }
                    default: {
                        this.codeAttributeEditor.replaceInstruction(offset, (Instruction)new SimpleInstruction(1));
                        this.popInstruction = new SimpleInstruction(87);
                    }
                }
                if (this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                break;
            }
            case -73: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                if (this.popInstruction == null) {
                    this.codeAttributeEditor.deleteInstruction(offset);
                    break;
                }
                this.codeAttributeEditor.replaceInstruction(offset, new Instruction[]{this.popInstruction, new SimpleInstruction(87)});
                break;
            }
            case -76: {
                if (!this.isReferencingWrapperClass(clazz, constantInstruction.constantIndex)) break;
                this.codeAttributeEditor.deleteInstruction(offset);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        if (methodrefConstant.getName(clazz).equals("<init>")) {
            methodrefConstant.referencedClassAccept((ClassVisitor)this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this);
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.wrappedClass = ClassMerger.getTargetClass((Clazz)programClass);
    }

    private boolean isReferencingWrapperClass(Clazz clazz, int constantIndex) {
        this.wrappedClass = null;
        clazz.constantPoolEntryAccept(constantIndex, (ConstantVisitor)this);
        return this.wrappedClass != null;
    }
}

