/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedTypeAdapterInitializer;
import proguard.util.ProcessingFlagSetter;

public class OptimizedTypeAdapterAdder
implements ClassVisitor {
    public static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationInfo;
    private final OptimizedJsonInfo deserializationInfo;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private final Map<String, String> typeAdapterRegistry;
    private final GsonRuntimeSettings gsonRuntimeSettings;

    public OptimizedTypeAdapterAdder(ClassPool programClassPool, ClassPool libraryClassPool, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo serializationInfo, OptimizedJsonInfo deserializationInfo, ExtraDataEntryNameMap extraDataEntryNameMap, Map<String, String> typeAdapterRegistry, GsonRuntimeSettings gsonRuntimeSettings) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationInfo = serializationInfo;
        this.deserializationInfo = deserializationInfo;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
        this.typeAdapterRegistry = typeAdapterRegistry;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        String externalClassName = ClassUtil.externalClassName((String)programClass.getName());
        String packageName = ClassUtil.externalPackageName((String)externalClassName);
        String shortClassName = ClassUtil.externalShortClassName((String)externalClassName);
        String externalTypeAdapterClassName = packageName + '.' + "Optimized" + shortClassName + "TypeAdapter";
        String typeAdapterClassName = ClassUtil.internalClassName((String)externalTypeAdapterClassName);
        if (this.programClassPool.getClass(typeAdapterClassName) == null) {
            ClassReader templateClassReader = new ClassReader(false, false, false, false, null, (ClassVisitor)new OptimizedTypeAdapterInitializer(typeAdapterClassName, programClass, this.codeAttributeEditor, this.serializationInfo, this.deserializationInfo, this.gsonRuntimeSettings.instanceCreatorClassPool, (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ProcessingFlagSetter(512), new ClassPresenceFilter(this.programClassPool, null, (ClassVisitor)new ClassPoolFiller(this.programClassPool)), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer()})));
            try {
                String dataEntryName = OptimizedTypeAdapterAdder.getDataEntryName("proguard/optimize/gson/_OptimizedTypeAdapterImpl");
                templateClassReader.read((DataEntry)new ClassPathDataEntry(dataEntryName));
                this.extraDataEntryNameMap.addExtraClassToClass((Clazz)programClass, typeAdapterClassName);
                this.typeAdapterRegistry.put(programClass.getName(), typeAdapterClassName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getDataEntryName(String internalClassName) {
        return internalClassName + ".class";
    }
}

