/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.Field;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.gson.GsonAnnotationCleaner;
import proguard.optimize.gson.GsonConstructorPatcher;
import proguard.optimize.gson.GsonContext;
import proguard.optimize.gson.GsonDeserializationOptimizer;
import proguard.optimize.gson.GsonSerializationOptimizer;
import proguard.optimize.gson.OptimizedJsonFieldCollector;
import proguard.optimize.gson.OptimizedJsonFieldVisitor;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedJsonReaderImplInitializer;
import proguard.optimize.gson.OptimizedJsonWriterImplInitializer;
import proguard.optimize.gson.OptimizedTypeAdapterAdder;
import proguard.optimize.gson.OptimizedTypeAdapterFactoryInitializer;
import proguard.util.ProcessingFlagSetter;
import proguard.util.StringUtil;

public class GsonOptimizer {
    public static final boolean DEBUG = false;
    private static final String[] TEMPLATE_CLASS_NAMES = new String[]{"proguard/optimize/gson/_OptimizedTypeAdapter", "proguard/optimize/gson/_GsonUtil", "proguard/optimize/gson/_OptimizedJsonReader", "proguard/optimize/gson/_OptimizedJsonReaderImpl", "proguard/optimize/gson/_OptimizedJsonWriter", "proguard/optimize/gson/_OptimizedJsonWriterImpl", "proguard/optimize/gson/_OptimizedTypeAdapterFactory"};
    private final Configuration configuration;

    public GsonOptimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap) throws IOException {
        programClassPool.classesAccept((ClassVisitor)new ClassNameFilter(StringUtil.join((String)",", (String[])new String[]{"com/google/gson/Gson", "com/google/gson/internal/Excluder"}), (ClassVisitor)new AllFieldVisitor((MemberVisitor)new MemberAccessSetter(1))));
        programClassPool.classesAccept((ClassVisitor)new ClassNameFilter("com/google/gson/Gson", (ClassVisitor)new MemberAccessFlagCleaner(16)));
        PrintWriter out = new PrintWriter(System.out, true);
        WarningPrinter warningPrinter = new WarningPrinter(out, this.configuration.warn);
        GsonContext gsonContext = new GsonContext();
        gsonContext.setupFor(programClassPool, libraryClassPool, warningPrinter);
        if (gsonContext.gsonDomainClassPool.size() > 0) {
            boolean addExcluder;
            OptimizedJsonInfo serializationInfo = new OptimizedJsonInfo();
            OptimizedJsonInfo deserializationInfo = new OptimizedJsonInfo();
            OptimizedJsonFieldCollector serializedFieldCollector = new OptimizedJsonFieldCollector(serializationInfo, OptimizedJsonFieldCollector.Mode.serialize);
            OptimizedJsonFieldCollector deserializedFieldCollector = new OptimizedJsonFieldCollector(deserializationInfo, OptimizedJsonFieldCollector.Mode.deserialize);
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new OptimizedJsonFieldVisitor(serializedFieldCollector, serializedFieldCollector), new OptimizedJsonFieldVisitor(deserializedFieldCollector, deserializedFieldCollector)}));
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new GsonAnnotationCleaner(gsonContext.gsonRuntimeSettings));
            serializationInfo.assignIndices();
            deserializationInfo.assignIndices();
            ClassReader helperClassReader = new ClassReader(false, false, false, false, null, (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ProcessingFlagSetter(512), new ClassPresenceFilter(programClassPool, null, (ClassVisitor)new ClassPoolFiller(programClassPool)), new ClassReferenceInitializer(programClassPool, libraryClassPool), new ClassSubHierarchyInitializer()}));
            for (String className : TEMPLATE_CLASS_NAMES) {
                helperClassReader.read((DataEntry)new ClassPathDataEntry(className + ".class"));
                extraDataEntryNameMap.addExtraClassToClass("com/google/gson/Gson", className);
            }
            BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, false);
            programClassPool.classesAccept("proguard/optimize/gson/_OptimizedJsonWriterImpl", (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()[Ljava/lang/String;", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new OptimizedJsonWriterImplInitializer(programClassPool, libraryClassPool, codeAttributeEditor, serializationInfo)))))}));
            programClassPool.classesAccept("proguard/optimize/gson/_OptimizedJsonReaderImpl", (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameFilter("a", (MemberVisitor)new MemberDescriptorFilter("()Ljava/util/Map;", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new OptimizedJsonReaderImplInitializer(programClassPool, libraryClassPool, codeAttributeEditor, deserializationInfo)))))}));
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new ClassAccessFilter(0, 16384, (ClassVisitor)new GsonSerializationOptimizer(programClassPool, libraryClassPool, gsonContext.gsonRuntimeSettings, serializationInfo, extraDataEntryNameMap)));
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new ClassAccessFilter(0, 16384, (ClassVisitor)new GsonDeserializationOptimizer(programClassPool, libraryClassPool, gsonContext.gsonRuntimeSettings, deserializationInfo, extraDataEntryNameMap)));
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool));
            HashMap<String, String> typeAdapterRegistry = new HashMap<String, String>();
            OptimizedTypeAdapterAdder optimizedTypeAdapterAdder = new OptimizedTypeAdapterAdder(programClassPool, libraryClassPool, codeAttributeEditor, serializationInfo, deserializationInfo, extraDataEntryNameMap, typeAdapterRegistry, gsonContext.gsonRuntimeSettings);
            gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)optimizedTypeAdapterAdder);
            programClassPool.classAccept("proguard/optimize/gson/_OptimizedTypeAdapterFactory", (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new PeepholeEditor(branchTargetFinder, codeAttributeEditor, (InstructionVisitor)new OptimizedTypeAdapterFactoryInitializer(programClassPool, codeAttributeEditor, typeAdapterRegistry, gsonContext.gsonRuntimeSettings)))), new ClassReferenceInitializer(programClassPool, libraryClassPool)}));
            ProgramClass gsonClass = (ProgramClass)programClassPool.getClass("com/google/gson/Gson");
            MemberCounter memberCounter = new MemberCounter();
            gsonClass.accept((ClassVisitor)new NamedFieldVisitor("excluder", "Lcom/google/gson/internal/Excluder;", (MemberVisitor)memberCounter));
            boolean bl = addExcluder = memberCounter.getCount() == 0;
            if (addExcluder) {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(gsonClass, programClassPool, libraryClassPool);
                int nameIndex = constantPoolEditor.addUtf8Constant("excluder");
                int descriptorIndex = constantPoolEditor.addUtf8Constant("Lcom/google/gson/internal/Excluder;");
                ProgramField field = new ProgramField(1, nameIndex, descriptorIndex, null);
                ClassEditor classEditor = new ClassEditor(gsonClass);
                classEditor.addField((Field)field);
                gsonClass.fieldsAccept((MemberVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool));
                gsonClass.constantPoolEntriesAccept((ConstantVisitor)new ClassReferenceInitializer(programClassPool, libraryClassPool));
            }
            programClassPool.classAccept("com/google/gson/Gson", (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor((MemberVisitor)new MemberNameFilter("<init>", (MemberVisitor)new GsonConstructorPatcher(codeAttributeEditor, addExcluder))), new ClassReferenceInitializer(programClassPool, libraryClassPool)}));
            if (this.configuration.verbose) {
                System.out.println("  Number of optimized serializable classes:      " + gsonContext.gsonDomainClassPool.size());
            }
        }
    }
}

