/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.util;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceReplacer;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.util.ReplacementSequences;

public class InstructionSequenceObfuscator
implements ClassVisitor,
MemberVisitor {
    private final PeepholeEditor peepholeEditor;

    public InstructionSequenceObfuscator(ReplacementSequences replacementSequences) {
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        this.peepholeEditor = new PeepholeEditor(branchTargetFinder, codeAttributeEditor, (InstructionVisitor)new MyInstructionSequenceReplacer(replacementSequences.getConstants(), replacementSequences.getSequences(), branchTargetFinder, codeAttributeEditor));
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.methodsAccept((MemberVisitor)this);
    }

    public void visitAnyMember(Clazz clazz, Member member) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, (AttributeVisitor)this.peepholeEditor);
    }

    private static class MyInstructionSequenceReplacer
    extends MultiInstructionVisitor {
        MyInstructionSequenceReplacer(Constant[] constants, Instruction[][][] insSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
            super(MyInstructionSequenceReplacer.createInstructionSequenceReplacers(constants, insSequences, branchTargetFinder, codeAttributeEditor));
        }

        private static InstructionVisitor[] createInstructionSequenceReplacers(Constant[] constants, Instruction[][][] insSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
            InstructionSequenceReplacer[] isReplacers = new InstructionSequenceReplacer[insSequences.length];
            Arrays.setAll(isReplacers, index -> new InstructionSequenceReplacer(constants, insSequences[index][0], constants, insSequences[index][1], branchTargetFinder, codeAttributeEditor, null));
            return isReplacers;
        }
    }
}

