/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import com.guardanis.netclient.tools.NetUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;

public class OutputStreamHelper {
    private OutputStream stream;
    private OutputStreamWriter writer;

    public OutputStreamHelper(OutputStream stream) {
        this.stream = stream;
    }

    public void writeOrIgnore(String params) throws IOException {
        if (!OutputStreamHelper.isWritingAllowed(params)) {
            return;
        }
        this.writer = new OutputStreamWriter(this.stream);
        this.writer.write(params);
        this.writer.flush();
    }

    public void closeConnection() {
        NetUtils.close(this.writer);
        this.stream = null;
    }

    public static OutputStreamHelper createWritableInstance(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        return new OutputStreamHelper(connection.getOutputStream());
    }

    public static boolean isWritingAllowed(String params) {
        return params != null && 0 < params.length();
    }
}

