/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import android.content.Context;
import com.guardanis.netclient.tools.NetUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class UrlParams {
    protected Context context;
    protected String preferenceTable;
    protected String preferencePrefix;
    protected Map<String, String> urlAdditions = new HashMap<String, String>();

    public UrlParams(Context context, String preferenceTable, String preferencePrefix) {
        this.context = context.getApplicationContext();
        this.preferenceTable = preferenceTable;
        this.preferencePrefix = preferencePrefix;
        for (Map.Entry map : context.getSharedPreferences(preferenceTable, 0).getAll().entrySet()) {
            try {
                if (!((String)map.getKey()).startsWith(preferencePrefix) || String.valueOf(map.getValue()).equals("")) continue;
                this.urlAdditions.put(((String)map.getKey()).substring(preferencePrefix.length()), String.valueOf(map.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public UrlParams register(String key, String value) {
        this.urlAdditions.put(key, value);
        this.context.getSharedPreferences(this.preferenceTable, 0).edit().putString(this.preferencePrefix + key, value).commit();
        return this;
    }

    public UrlParams unregister(String key) {
        this.urlAdditions.remove(key);
        this.context.getSharedPreferences(this.preferenceTable, 0).edit().remove(this.preferencePrefix + key).commit();
        return this;
    }

    public String addAdditions(String url) throws UnsupportedEncodingException {
        if (!this.urlAdditions.isEmpty()) {
            url = url + (url.contains("?") ? "&" : "?");
            url = url + NetUtils.getInstance(this.context).encodeParams(this.urlAdditions);
        }
        return url;
    }
}

