/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.batch;

import com.guardanis.netclient.batch.BatchItemResponse;
import com.guardanis.netclient.errors.RequestError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BatchError
extends RequestError {
    protected final Map<String, BatchItemResponse> itemResponses;

    public BatchError(Map<String, BatchItemResponse> itemResponses) {
        super("");
        this.itemResponses = itemResponses;
        this.errors = new ArrayList();
        for (BatchItemResponse itemResponse : itemResponses.values()) {
            if (!itemResponse.hasErrors()) continue;
            for (String message : itemResponse.getError().getErrors()) {
                if (this.errors.contains(message)) continue;
                this.errors.add(message);
            }
        }
    }

    public Map<String, BatchItemResponse> getItemResponses() {
        return this.itemResponses;
    }

    public Map<String, BatchItemResponse> getItemResponseFailures() {
        HashMap<String, BatchItemResponse> failures = new HashMap<String, BatchItemResponse>();
        for (BatchItemResponse item : this.itemResponses.values()) {
            if (!item.hasErrors()) continue;
            failures.put(item.getBatchable().getKey(), item);
        }
        return failures;
    }
}

