/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import android.content.Context;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public class RequestProperties {
    protected Context context;
    protected String preferenceTable;
    protected String preferencePrefix;
    protected Map<String, String> requestProperties = new HashMap<String, String>();

    public RequestProperties(Context context, String preferenceTable, String preferencePrefix) {
        this.context = context.getApplicationContext();
        this.preferenceTable = preferenceTable;
        this.preferencePrefix = preferencePrefix;
        for (Map.Entry map : context.getSharedPreferences(preferenceTable, 0).getAll().entrySet()) {
            try {
                if (!((String)map.getKey()).startsWith(preferencePrefix) || String.valueOf(map.getValue()).equals("")) continue;
                this.requestProperties.put(((String)map.getKey()).substring(preferencePrefix.length()), String.valueOf(map.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RequestProperties register(String key, String value) {
        this.requestProperties.put(key, value);
        this.context.getSharedPreferences(this.preferenceTable, 0).edit().putString(this.preferencePrefix + key, value).commit();
        return this;
    }

    public RequestProperties unregister(String key) {
        this.requestProperties.remove(key);
        this.context.getSharedPreferences(this.preferenceTable, 0).edit().remove(this.preferencePrefix + key).commit();
        return this;
    }

    public RequestProperties addProperties(HttpURLConnection conn) {
        for (String key : this.requestProperties.keySet()) {
            conn.setRequestProperty(key, this.requestProperties.get(key));
        }
        return this;
    }
}

