/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.errors;

import android.content.Context;
import com.guardanis.netclient.R;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;

public class RequestError {
    protected List<String> errors = new ArrayList<String>();
    private Throwable throwable;
    private boolean connectionIssue = false;

    public RequestError(Context context, Throwable throwable) {
        this.throwable = throwable;
        if (this.isLikelyConnectionError(throwable)) {
            this.connectionIssue = true;
            this.errors.add(context.getResources().getString(R.string.nc__error_connection));
        } else {
            this.errors.add(context.getResources().getString(R.string.nc__error_unknown));
        }
    }

    public RequestError(String error) {
        this.errors.add(error);
    }

    public RequestError(List<String> errors) {
        this.errors = errors;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return 0 < this.errors.size();
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String delimiter) {
        if (this.errors == null || this.errors.size() < 1) {
            return "Something went wrong.";
        }
        String errorMessage = this.errors.get(0);
        for (int i = 1; i < this.errors.size(); ++i) {
            errorMessage = errorMessage + delimiter + this.errors.get(i);
        }
        return errorMessage;
    }

    protected boolean isLikelyConnectionError(Throwable throwable) {
        return throwable != null && (throwable instanceof SocketTimeoutException || throwable instanceof SocketException || throwable instanceof InterruptedIOException || throwable instanceof UnknownHostException || throwable instanceof SSLException);
    }

    public boolean isKnownConnectionIssue() {
        return this.connectionIssue;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

