/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import android.content.Context;
import android.util.Log;
import com.guardanis.netclient.R;
import com.guardanis.netclient.errors.DefaultErrorParser;
import com.guardanis.netclient.errors.ErrorParser;
import it.sauronsoftware.base64.Base64;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;

public class NetUtils {
    private static NetUtils instance;
    private static final String TAG = "netclient";
    private static final String PREFS = "nc__netutils_preferences";
    private static final String PREF__GENERAL_ERROR_PARSER_CLASS = "nc__general_error_parser";
    private static final String PREF__API_ERROR_PARSER_CLASS = "nc__api_error_parser";
    private Context context;
    private String apiUrl;
    private boolean loggingEnabled;
    private ErrorParser generalErrorParser;
    private ErrorParser apiErrorParser;

    public static NetUtils getInstance(Context context) {
        if (instance == null) {
            instance = new NetUtils(context);
        }
        return instance;
    }

    protected NetUtils(Context context) {
        this.context = context.getApplicationContext();
        this.apiUrl = context.getString(R.string.nc__api_url);
        this.loggingEnabled = context.getResources().getBoolean(R.bool.nc__log_enabled);
        this.generalErrorParser = this.loadErrorParserClass(PREF__GENERAL_ERROR_PARSER_CLASS);
        this.apiErrorParser = this.loadErrorParserClass(PREF__API_ERROR_PARSER_CLASS);
    }

    private ErrorParser loadErrorParserClass(String key) {
        try {
            return (ErrorParser)Class.forName(this.context.getSharedPreferences(PREFS, 0).getString(key, DefaultErrorParser.class.getName())).newInstance();
        }
        catch (Throwable e) {
            this.log(e.getMessage());
            if (this.context.getResources().getBoolean(R.bool.nc__default_on_error_parser_load_failure)) {
                return new DefaultErrorParser();
            }
            throw new RuntimeException(e);
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public NetUtils overrideApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    public void addBasicAuthRequestProperty(HttpURLConnection conn) {
        if (this.isBasicAuthEnabled()) {
            conn.setRequestProperty("Authorization", "Basic " + this.getBasicAuthEncodedHeader());
        }
    }

    private String getBasicAuthEncodedHeader() {
        String value = this.context.getString(R.string.nc__api_basic_auth_username) + ":" + this.context.getString(R.string.nc__api_basic_auth_password);
        return new String(Base64.encode((String)value).getBytes());
    }

    public boolean isBasicAuthEnabled() {
        return this.context.getResources().getBoolean(R.bool.nc__api_basic_auth_enabled);
    }

    public void addVersionRequestProperty(HttpURLConnection conn) {
        if (this.isApiVersionHeaderEnabled()) {
            conn.setRequestProperty(this.context.getString(R.string.nc__api_version_header_name), this.context.getString(R.string.nc__api_version_header_value));
        }
    }

    public boolean isApiVersionHeaderEnabled() {
        return this.context.getResources().getBoolean(R.bool.nc__api_version_header_enabled);
    }

    public String getContentTypeProperty() {
        return this.context.getString(R.string.nc__api_property_content_type);
    }

    public String getAcceptProperty() {
        return this.context.getString(R.string.nc__api_property_accept);
    }

    public String encodeParams(Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null) {
            return "";
        }
        String encoded = "";
        for (String key : params.keySet()) {
            encoded = encoded + this.getUrlEncodedValue(key) + "=" + this.getUrlEncodedValue(params.get(key)) + "&";
        }
        return encoded.substring(0, encoded.length() - 1);
    }

    public String getUrlEncodedValue(String toEncode) throws UnsupportedEncodingException {
        return URLEncoder.encode(toEncode, this.context.getString(R.string.nc__api_encoding));
    }

    public NetUtils setGeneralErrorParser(Class parserClass) {
        try {
            ErrorParser parser;
            this.generalErrorParser = parser = (ErrorParser)Class.forName(parserClass.getName()).newInstance();
        }
        catch (Throwable e) {
            this.log(e.getMessage());
            throw new RuntimeException(e);
        }
        this.context.getSharedPreferences(PREFS, 0).edit().putString(PREF__GENERAL_ERROR_PARSER_CLASS, parserClass.getName()).commit();
        return this;
    }

    public ErrorParser getGeneralErrorParser() {
        return this.generalErrorParser;
    }

    public NetUtils setApiErrorParser(Class parserClass) {
        try {
            ErrorParser parser;
            this.apiErrorParser = parser = (ErrorParser)Class.forName(parserClass.getName()).newInstance();
        }
        catch (Throwable e) {
            this.log(e.getMessage());
            throw new RuntimeException(e);
        }
        this.context.getSharedPreferences(PREFS, 0).edit().putString(PREF__API_ERROR_PARSER_CLASS, parserClass.getName()).commit();
        return this;
    }

    public ErrorParser getApiErrorParser() {
        return this.apiErrorParser;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void log(String message) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)message);
        }
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }
}

