/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.batch;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Patterns;
import com.guardanis.netclient.ApiRequest;
import com.guardanis.netclient.NetInterface;
import com.guardanis.netclient.R;
import com.guardanis.netclient.WebRequest;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.batch.BatchItemResponse;
import com.guardanis.netclient.batch.BatchResponse;
import com.guardanis.netclient.batch.Batchable;
import com.guardanis.netclient.batch.BatchableManager;
import com.guardanis.netclient.errors.RequestError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchRequest {
    protected Context context;
    protected List<Batchable> batchableItems = new ArrayList<Batchable>();
    protected NetInterface.SuccessListener<BatchResponse> batchSuccessListener;
    protected Map<String, List<NetInterface.SuccessListener>> itemSuccessListeners = new LinkedHashMap<String, List<NetInterface.SuccessListener>>();
    protected NetInterface.FailListener failListener;
    protected List<WebRequest> requests;
    protected boolean canceled = false;
    protected boolean failOnCancel = true;
    protected boolean postedFailures = false;
    protected List<BatchItemResponse> responses = new ArrayList<BatchItemResponse>();
    protected boolean autoDelegateApiRequests = true;

    public BatchRequest(Context context) {
        this.context = context.getApplicationContext();
    }

    public BatchRequest add(Batchable batchable) {
        this.batchableItems.add(batchable);
        return this;
    }

    public BatchRequest applyFrom(BatchableManager batchableManager, long cacheDuration) {
        Batchable batchable = batchableManager.buildBatchable(this.context, cacheDuration);
        this.add(batchable);
        this.onItemSuccess(batchable.getKey(), batchableManager.buildBatchableSuccessListener(this.context));
        return this;
    }

    public <T> BatchRequest onItemSuccess(String key, NetInterface.SuccessListener<T> successListener) {
        if (this.itemSuccessListeners.get(key) == null) {
            this.itemSuccessListeners.put(key, new ArrayList());
        }
        this.itemSuccessListeners.get(key).add(successListener);
        return this;
    }

    public BatchRequest onBatchSuccess(NetInterface.SuccessListener<BatchResponse> successListener) {
        this.batchSuccessListener = successListener;
        return this;
    }

    public BatchRequest onBatchFail(NetInterface.FailListener failListener) {
        this.failListener = failListener;
        return this;
    }

    public BatchRequest setFailOnCancel(boolean failOnCancel) {
        this.failOnCancel = failOnCancel;
        return this;
    }

    public BatchRequest execute() {
        if (this.requests != null || this.postedFailures) {
            throw new RuntimeException("You cannot restart a BatchRequest!");
        }
        if (this.batchableItems.size() < 1) {
            throw new RuntimeException("You never added any Batchables!");
        }
        this.requests = new ArrayList<WebRequest>();
        for (Batchable batchable : this.batchableItems) {
            this.requests.add(this.buildBatchRequest(batchable).execute());
        }
        return this;
    }

    protected WebRequest<BatchItemResponse> buildBatchRequest(Batchable batchable) {
        if (!this.autoDelegateApiRequests || Patterns.WEB_URL.matcher(batchable.getUrl()).matches()) {
            return this.buildWebRequest(batchable);
        }
        return this.buildApiRequest(batchable);
    }

    protected WebRequest<BatchItemResponse> buildWebRequest(Batchable batchable) {
        WebRequest<BatchItemResponse> request = new WebRequest<BatchItemResponse>(this.context, WebRequest.ConnectionType.GET, batchable.getUrl());
        return this.configureRequest(request, batchable);
    }

    protected WebRequest<BatchItemResponse> buildApiRequest(Batchable batchable) {
        ApiRequest<BatchItemResponse> request = new ApiRequest<BatchItemResponse>(this.context, WebRequest.ConnectionType.GET, batchable.getUrl());
        return this.configureRequest(request, batchable);
    }

    protected WebRequest<BatchItemResponse> configureRequest(WebRequest<BatchItemResponse> request, Batchable batchable) {
        request.setCacheDurationMs(batchable.getMaxCacheDuration()).setResponseParser(new BatchItemParser(batchable)).onSuccess(new BatchItemSuccessListener(batchable)).onFail(new BatchItemFailListener(batchable));
        Map<String, String> properties = batchable.getRequestProperties();
        for (Map.Entry<String, String> item : properties.entrySet()) {
            request.addRequestProperty(item.getKey(), item.getValue());
        }
        return request;
    }

    protected void onDataReceived() {
        if (!this.canceled && this.responses.size() == this.batchableItems.size()) {
            this.processResponses();
        }
    }

    protected void processResponses() {
        ArrayList<String> errors = new ArrayList<String>();
        for (BatchItemResponse response : this.responses) {
            if (!response.hasErrors()) continue;
            errors.addAll(response.getError().getErrors());
        }
        if (0 < errors.size()) {
            if (!this.canceled || this.failOnCancel) {
                this.safelyPostFailure(new RequestError(errors));
            }
            return;
        }
        BatchResponse response = new BatchResponse();
        for (BatchItemResponse item : this.responses) {
            response.put(item);
        }
        this.postSuccessfulData(response);
    }

    protected void postSuccessfulData(final BatchResponse response) {
        if (this.canceled || this.postedFailures) {
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                for (String key : BatchRequest.this.itemSuccessListeners.keySet()) {
                    for (NetInterface.SuccessListener listener : BatchRequest.this.itemSuccessListeners.get(key)) {
                        listener.onSuccess(((BatchItemResponse)response.get(key)).getData());
                    }
                }
                if (BatchRequest.this.batchSuccessListener != null) {
                    BatchRequest.this.batchSuccessListener.onSuccess(response);
                }
            }
        });
    }

    public void cancel() {
        this.canceled = true;
        if (this.failOnCancel) {
            this.safelyPostFailure(new RequestError(this.context.getString(R.string.nc__error_canceled)));
        }
        if (this.requests != null) {
            for (WebRequest request : this.requests) {
                request.cancel();
            }
        }
    }

    protected void safelyPostFailure(final RequestError error) {
        if (this.postedFailures) {
            return;
        }
        this.postedFailures = true;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (BatchRequest.this.failListener != null) {
                    BatchRequest.this.failListener.onFail(error);
                }
            }
        });
    }

    public BatchRequest setAutoDelegateApiRequests(boolean autoDelegateApiRequests) {
        this.autoDelegateApiRequests = autoDelegateApiRequests;
        return this;
    }

    protected class BatchItemFailListener
    implements NetInterface.FailListener {
        protected final Batchable batchable;

        public BatchItemFailListener(Batchable batchable) {
            this.batchable = batchable;
        }

        @Override
        public void onFail(RequestError error) {
            BatchRequest.this.responses.add(new BatchItemResponse(this.batchable).setError(error));
            BatchRequest.this.onDataReceived();
        }
    }

    protected class BatchItemSuccessListener
    implements NetInterface.SuccessListener<BatchItemResponse> {
        protected final Batchable batchable;

        public BatchItemSuccessListener(Batchable batchable) {
            this.batchable = batchable;
        }

        @Override
        public void onSuccess(BatchItemResponse result) {
            BatchRequest.this.responses.add(result);
            BatchRequest.this.onDataReceived();
        }
    }

    protected static class BatchItemParser
    implements NetInterface.ResponseParser<BatchItemResponse> {
        protected final Batchable batchable;

        public BatchItemParser(Batchable batchable) {
            this.batchable = batchable;
        }

        @Override
        public BatchItemResponse parse(WebResult result) throws Exception {
            return new BatchItemResponse(this.batchable).setResult(result, this.batchable.getResponseParser().parse(result));
        }
    }
}

