/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.guardanis.netclient.CustomSSLSocketFactory;
import com.guardanis.netclient.NetInterface;
import com.guardanis.netclient.R;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.errors.ApiError;
import com.guardanis.netclient.errors.ErrorParser;
import com.guardanis.netclient.errors.GeneralError;
import com.guardanis.netclient.errors.RequestCanceledError;
import com.guardanis.netclient.errors.RequestError;
import com.guardanis.netclient.errors.RequestTimeoutError;
import com.guardanis.netclient.tools.CacheManager;
import com.guardanis.netclient.tools.InputStreamHelper;
import com.guardanis.netclient.tools.NetUtils;
import com.guardanis.netclient.tools.OutputStreamHelper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class WebRequest<T>
implements Runnable {
    private static final int CORE_POOL_SIZE = 15;
    private static final int MAXIMUM_POOL_SIZE = 64;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "NetTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> THREAD_POOL_QUEUE = new LinkedBlockingQueue<Runnable>(30);
    protected static final Executor EXECUTOR = new ThreadPoolExecutor(15, 64, 1L, TimeUnit.SECONDS, THREAD_POOL_QUEUE, sThreadFactory);
    protected Context context;
    protected ConnectionType connectionType;
    protected String targetUrl = "";
    protected Map<String, String> requestProperties = new HashMap<String, String>();
    protected String data;
    protected NetInterface.ResponseParser<T> responseParser;
    protected NetInterface.SuccessListener<T> successListener;
    protected NetInterface.FailListener failListener;
    protected Looper originatingLooper;
    protected boolean requestExecuted = false;
    protected boolean responseReceived = false;
    protected boolean canceled = false;
    protected boolean failOnCancel = false;
    protected ErrorParser errorParser;
    protected boolean customSslModeEnabled = false;
    protected boolean unsafeSslModeEnabled = false;
    protected int sslCertResource = R.raw.nc__cert;
    protected String sslCertPassword;
    protected long connectionTimeoutMs = 25000L;
    protected String cacheCypher;
    protected long cacheDurationMs = 0L;

    public WebRequest(Context context, ConnectionType connectionType) {
        this(context, connectionType, "");
    }

    public WebRequest(Context context, ConnectionType connectionType, String targetUrl) {
        this.context = context;
        this.connectionType = connectionType;
        this.customSslModeEnabled = context.getResources().getBoolean(R.bool.nc__custom_ssl_mode_enabled);
        this.sslCertPassword = context.getString(R.string.nc__ssl_cert_keystore_password);
        this.cacheCypher = context.getString(R.string.nc__cache_encryption_cypher);
        this.connectionTimeoutMs = (long)context.getResources().getInteger(R.integer.nc__connection_timeout_seconds) * 1000L;
        this.setTargetUrl(targetUrl);
    }

    public WebRequest<T> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl.trim();
        return this;
    }

    public WebRequest<T> setData(NetInterface.Jsonable data) {
        return this.setData(data.toJson());
    }

    public WebRequest<T> setData(JSONObject data) {
        return this.setData(data.toString());
    }

    public WebRequest<T> setData(String data) {
        this.data = data;
        return this;
    }

    public WebRequest<T> addRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
        return this;
    }

    public WebRequest<T> setResponseParser(NetInterface.ResponseParser<T> responseParser) {
        this.responseParser = responseParser;
        return this;
    }

    public WebRequest<T> onSuccess(NetInterface.SuccessListener<T> successListener) {
        this.successListener = successListener;
        return this;
    }

    public WebRequest<T> onFail(NetInterface.FailListener failListener) {
        this.failListener = failListener;
        return this;
    }

    public WebRequest<T> setFailOnCancel(boolean failOnCancel) {
        this.failOnCancel = failOnCancel;
        return this;
    }

    public WebRequest<T> setErrorParser(ErrorParser errorParser) {
        this.errorParser = errorParser;
        return this;
    }

    public WebRequest<T> setCustomSslModeEnabled(boolean customSslModeEnabled) {
        this.customSslModeEnabled = customSslModeEnabled;
        return this;
    }

    public WebRequest<T> setSslCertificateInfo(int sslCertResource, String sslCertPassword) {
        this.sslCertResource = sslCertResource;
        this.sslCertPassword = sslCertPassword;
        this.customSslModeEnabled = true;
        return this;
    }

    public WebRequest<T> setSslUnsafeModeEnabled(boolean unsafeSslModeEnabled) {
        this.unsafeSslModeEnabled = unsafeSslModeEnabled;
        return this;
    }

    public WebRequest<T> setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
        return this;
    }

    public WebRequest<T> setCacheCypher(String cacheCypher) {
        this.cacheCypher = cacheCypher;
        return this;
    }

    public WebRequest<T> setCacheDurationMs(long cacheDurationMs) {
        this.cacheDurationMs = cacheDurationMs;
        return this;
    }

    public WebRequest<T> execute() {
        if (this.requestExecuted) {
            throw new RuntimeException("You should not execute a WebRequest that has already been run before!");
        }
        this.requestExecuted = true;
        this.originatingLooper = Looper.myLooper();
        EXECUTOR.execute(new Thread(this));
        return this;
    }

    @Override
    public void run() {
        this.startTimeoutMonitoring();
        try {
            WebResult result = this.getCachedData();
            if (result == null) {
                result = this.processNetworkRequest();
            }
            this.responseReceived = true;
            if (!this.canceled) {
                this.processResponse(result);
            }
        }
        catch (Throwable e) {
            this.responseReceived = true;
            this.postToOriginalThread(new Runnable(){

                @Override
                public void run() {
                    if (WebRequest.this.failListener != null) {
                        WebRequest.this.failListener.onFail(new GeneralError(WebRequest.this.context, e));
                    }
                }
            });
            e.printStackTrace();
        }
    }

    protected WebResult getCachedData() throws Exception {
        if (this.connectionType == ConnectionType.GET && 0L < this.cacheDurationMs) {
            return CacheManager.getInstance(this.context).get(this.getCacheKey(), this.cacheCypher, this.cacheDurationMs);
        }
        return null;
    }

    protected WebResult processNetworkRequest() throws Exception {
        HttpURLConnection connection = this.openConnection();
        if (this.connectionType == ConnectionType.POST) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(this.connectionType.name());
        this.setRequestProperties(connection);
        return this.makeRequest(connection, this.data);
    }

    protected HttpURLConnection openConnection() throws Exception {
        URL url = this.buildUrl();
        if (this.customSslModeEnabled && this.targetUrl.startsWith("https://")) {
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            CustomSSLSocketFactory factory = this.unsafeSslModeEnabled ? CustomSSLSocketFactory.getUnsafeInstance() : CustomSSLSocketFactory.getInstance(this.context, this.sslCertResource, this.sslCertPassword);
            conn.setSSLSocketFactory(factory.currentContext.getSocketFactory());
            return conn;
        }
        return (HttpURLConnection)url.openConnection();
    }

    protected void setRequestProperties(HttpURLConnection conn) {
        conn.setRequestProperty("Accept", NetUtils.getInstance(this.context).getAcceptProperty());
        conn.setRequestProperty("Content-type", NetUtils.getInstance(this.context).getContentTypeProperty());
        for (String key : this.requestProperties.keySet()) {
            conn.setRequestProperty(key, this.requestProperties.get(key));
        }
    }

    protected URL buildUrl() throws MalformedURLException, UnsupportedEncodingException {
        return new URL(this.targetUrl);
    }

    protected WebResult makeRequest(HttpURLConnection conn, String params) throws Exception {
        OutputStreamHelper streamHelper = new OutputStreamHelper(conn);
        streamHelper.write(params);
        WebResult response = this.readResponse(conn);
        streamHelper.closeConnection();
        NetUtils.getInstance(this.context).log("Server response: " + response.getUnparsedResponse());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebResult readResponse(HttpURLConnection conn) throws Exception {
        InputStreamHelper streamHelper = null;
        String response = "";
        try {
            streamHelper = new InputStreamHelper(conn);
            response = streamHelper.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (streamHelper != null) {
                streamHelper.closeConnection();
            }
        }
        return new WebResult(conn.getResponseCode(), response);
    }

    protected void processResponse(WebResult result) throws Exception {
        RequestError errors = this.getErrorsFromResult(result);
        if (errors != null && errors.hasErrors()) {
            this.failWith(errors);
        } else {
            if (this.connectionType == ConnectionType.GET && 0L < this.cacheDurationMs) {
                CacheManager.getInstance(this.context).cache(this.buildUrl().toString(), this.cacheCypher, result);
            }
            this.finishWith(this.responseParser.parse(result));
        }
    }

    protected RequestError getErrorsFromResult(WebResult result) {
        ErrorParser activeParser = this.getErrorParser();
        List<String> errors = activeParser == null ? null : activeParser.parseErrorMessages(this.context, result);
        return errors == null || errors.size() < 1 ? null : new ApiError(result, errors);
    }

    protected ErrorParser getErrorParser() {
        return this.errorParser == null ? NetUtils.getInstance(this.context).getGeneralErrorParser() : this.errorParser;
    }

    protected String getCacheKey() {
        try {
            return this.buildUrl().toString();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to build cache key for URL from " + this.targetUrl);
        }
    }

    protected void failWith(final RequestError errors) {
        this.postToOriginalThread(new Runnable(){

            @Override
            public void run() {
                if (WebRequest.this.failListener != null) {
                    WebRequest.this.failListener.onFail(errors);
                }
            }
        });
    }

    protected void finishWith(final T parsedResult) {
        this.postToOriginalThread(new Runnable(){

            @Override
            public void run() {
                if (WebRequest.this.successListener != null) {
                    WebRequest.this.successListener.onSuccess(parsedResult);
                }
            }
        });
    }

    protected void postToOriginalThread(Runnable runnable) {
        try {
            if (this.canceled) {
                return;
            }
            new Handler(this.originatingLooper).post(runnable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.failOnCancel) {
            new Handler(this.originatingLooper).post(new Runnable(){

                @Override
                public void run() {
                    if (WebRequest.this.failListener != null) {
                        WebRequest.this.failListener.onFail(new RequestCanceledError(WebRequest.this.context));
                    }
                }
            });
        }
    }

    protected void startTimeoutMonitoring() {
        if (this.connectionTimeoutMs < 1L) {
            return;
        }
        new Handler(this.originatingLooper).postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!WebRequest.this.responseReceived && !WebRequest.this.canceled) {
                    WebRequest.this.canceled = true;
                    if (WebRequest.this.failListener != null) {
                        WebRequest.this.failListener.onFail(new RequestTimeoutError(WebRequest.this.context));
                    }
                }
            }
        }, this.connectionTimeoutMs);
    }

    public static Executor getRequestExecutor() {
        return EXECUTOR;
    }

    public static enum ConnectionType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

