/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import com.guardanis.netclient.GlobalApiUrlParams;
import com.guardanis.netclient.WebRequest;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.errors.ApiError;
import com.guardanis.netclient.errors.RequestError;
import com.guardanis.netclient.tools.NetUtils;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ApiRequest<T>
extends WebRequest<T> {
    public ApiRequest(Context context, WebRequest.ConnectionType connectionType) {
        super(context, connectionType);
    }

    public ApiRequest(Context context, WebRequest.ConnectionType connectionType, String targetUrl) {
        super(context, connectionType, targetUrl);
    }

    @Override
    public ApiRequest<T> setTargetUrl(String targetUrl) {
        this.targetUrl = NetUtils.getInstance(this.context).getApiUrl() + targetUrl.trim();
        return this;
    }

    @Override
    protected void setRequestProperties(HttpURLConnection conn) {
        super.setRequestProperties(conn);
        NetUtils.getInstance(this.context).addBasicAuthRequestProperty(conn);
        NetUtils.getInstance(this.context).addVersionRequestProperty(conn);
        conn.setRequestProperty("Accept-Encoding", NetUtils.getInstance(this.context).getAcceptEncodingProperty());
    }

    @Override
    protected URL buildUrl() throws MalformedURLException {
        return new URL(GlobalApiUrlParams.getInstance(this.context).addAdditions(this.targetUrl));
    }

    @Override
    protected RequestError getErrorsFromResult(WebResult result) {
        if (this.errorParser == null) {
            return NetUtils.getDefaultApiErrorParser() == null ? null : new ApiError(result, NetUtils.getDefaultApiErrorParser());
        }
        return super.getErrorsFromResult(result);
    }
}

