/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import android.content.Context;
import android.util.Log;
import com.guardanis.netclient.R;
import it.sauronsoftware.base64.Base64;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;

public class NetUtils {
    private static NetUtils instance;
    private static final String TAG = "netclient";
    private Context context;
    private String apiUrl;
    private boolean loggingEnabled;

    public static NetUtils getInstance(Context context) {
        if (instance == null) {
            instance = new NetUtils(context);
        }
        return instance;
    }

    protected NetUtils(Context context) {
        this.context = context.getApplicationContext();
        this.apiUrl = context.getString(R.string.nc__api_url);
        this.loggingEnabled = context.getResources().getBoolean(R.bool.nc__log_enabled);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void overrideApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void addBasicAuthRequestProperty(HttpURLConnection conn) {
        if (this.isBasicAuthEnabled()) {
            conn.setRequestProperty("Authorization", "Basic " + this.getBasicAuthEncodedHeader());
        }
    }

    private String getBasicAuthEncodedHeader() {
        String value = this.context.getString(R.string.nc__api_basic_auth_username) + ":" + this.context.getString(R.string.nc__api_basic_auth_password);
        return new String(Base64.encode((String)value).getBytes());
    }

    public boolean isBasicAuthEnabled() {
        return this.context.getResources().getBoolean(R.bool.nc__api_basic_auth_enabled);
    }

    public void addVersionRequestProperty(HttpURLConnection conn) {
        if (this.isBasicAuthEnabled()) {
            conn.setRequestProperty(this.context.getString(R.string.nc__api_version_header_name), this.context.getString(R.string.nc__api_version_header_value));
        }
    }

    public boolean isApiVersionHeaderEnabled() {
        return this.context.getResources().getBoolean(R.bool.nc__api_version_header_enabled);
    }

    public String getContentTypeProperty() {
        return this.context.getString(R.string.nc__api_property_content_type);
    }

    public String getAcceptProperty() {
        return this.context.getString(R.string.nc__api_property_accept);
    }

    public String getAcceptEncodingProperty() {
        return this.context.getString(R.string.nc__api_property_accept_encoding);
    }

    public String encodeParams(Map<String, String> params) throws Exception {
        if (params == null) {
            return "";
        }
        String encoded = "";
        for (String key : params.keySet()) {
            encoded = encoded + this.getUrlEncodedValue(key) + "=" + this.getUrlEncodedValue(params.get(key)) + "&";
        }
        return encoded.substring(0, encoded.length() - 1);
    }

    public String getUrlEncodedValue(String toEncode) throws Exception {
        return URLEncoder.encode(toEncode, this.context.getString(R.string.nc__api_encoding));
    }

    public void log(String message) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)message);
        }
    }
}

