/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;

public class InputStreamHelper {
    private InputStream inputStream;

    public InputStreamHelper(HttpURLConnection conn) throws NullPointerException, IOException {
        this.inputStream = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
        String contentEncoding = conn.getContentEncoding();
        if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
            this.inputStream = new GZIPInputStream(this.inputStream);
        }
    }

    public String read() throws IOException {
        String line;
        String response = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
        while ((line = reader.readLine()) != null) {
            response = response + line;
        }
        reader.close();
        return response;
    }

    public void closeConnection() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

