/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import com.guardanis.netclient.GlobalApiUrlParams;
import com.guardanis.netclient.WebRequest;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.errors.ApiError;
import com.guardanis.netclient.errors.DefaultErrorParser;
import com.guardanis.netclient.tools.NetUtils;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ApiRequest<T>
extends WebRequest<T> {
    public ApiRequest(Context context, WebRequest.ConnectionType connectionType) {
        super(context, connectionType);
    }

    public ApiRequest(Context context, WebRequest.ConnectionType connectionType, String targetUrl) {
        super(context, connectionType, targetUrl);
    }

    @Override
    protected void setRequestProperties(HttpURLConnection conn) {
        super.setRequestProperties(conn);
        NetUtils.getInstance(this.context).addBasicAuthRequestProperty(conn);
        NetUtils.getInstance(this.context).addVersionRequestProperty(conn);
        conn.setRequestProperty("Accept-Encoding", NetUtils.getInstance(this.context).getAcceptEncodingProperty());
    }

    @Override
    protected URL buildUrl() throws MalformedURLException {
        return new URL(GlobalApiUrlParams.getInstance(this.context).addAdditions(this.targetUrl));
    }

    @Override
    protected void onResponseReceived(WebResult result) throws Exception {
        final ApiError errors = new ApiError(result, new DefaultErrorParser(this.context));
        if (errors.hasErrors()) {
            this.postToOriginalThread(new Runnable(){

                @Override
                public void run() {
                    if (ApiRequest.this.failListener != null) {
                        ApiRequest.this.failListener.onFail(errors);
                    }
                }
            });
        } else {
            super.onResponseReceived(result);
        }
    }
}

