/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import com.guardanis.netclient.tools.NetUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class GlobalApiUrlParams {
    private static GlobalApiUrlParams instance;
    private static final String PREFS = "nc__global_api_url_params";
    private static final String PREF_KEY_PRE = "addition_";
    private Context context;
    private Map<String, String> globalUrlAdditions = new HashMap<String, String>();

    public static GlobalApiUrlParams getInstance(Context context) {
        if (instance == null) {
            instance = new GlobalApiUrlParams(context);
        }
        return instance;
    }

    protected GlobalApiUrlParams(Context context) {
        this.context = context.getApplicationContext();
        for (Map.Entry map : context.getSharedPreferences(PREFS, 0).getAll().entrySet()) {
            try {
                if (!((String)map.getKey()).startsWith(PREF_KEY_PRE) || String.valueOf(map.getValue()).equals("")) continue;
                this.globalUrlAdditions.put(((String)map.getKey()).substring(PREF_KEY_PRE.length()), String.valueOf(map.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GlobalApiUrlParams register(String key, String value) {
        this.globalUrlAdditions.put(key, value);
        this.context.getSharedPreferences(PREFS, 0).edit().putString(PREF_KEY_PRE + key, value).commit();
        return this;
    }

    public GlobalApiUrlParams unregister(String key) {
        this.globalUrlAdditions.remove(key);
        this.context.getSharedPreferences(PREFS, 0).edit().remove(PREF_KEY_PRE + key).commit();
        return this;
    }

    public String addAdditions(String url) throws UnsupportedEncodingException {
        if (!this.globalUrlAdditions.isEmpty()) {
            url = url + (url.contains("?") ? "&" : "?");
            url = url + NetUtils.getInstance(this.context).encodeParams(this.globalUrlAdditions);
        }
        NetUtils.getInstance(this.context).log("URL (with additions): " + url);
        return url;
    }
}

