/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient.errors;

import android.content.Context;
import com.guardanis.netclient.R;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.errors.ErrorParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultErrorParser
implements ErrorParser {
    private Context context;

    public DefaultErrorParser(Context context) {
        this.context = context;
    }

    @Override
    public List<String> parseErrorMessages(WebResult result) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!result.isSuccessful() || !result.isResponseCodeKnown()) {
            JSONObject obj = null;
            try {
                obj = new JSONObject(result.getUnparsedResponse());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result.isResponseCodeKnown() && obj == null) {
                errorMessages.add(this.context.getString(R.string.nc__error_unknown));
            } else if (obj != null) {
                this.parseErrors(result, obj);
            }
        }
        return errorMessages;
    }

    private List<String> parseErrors(WebResult result, JSONObject obj) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        JSONObject errors = obj.optJSONObject("errors");
        if (errors == null && !result.isSuccessful()) {
            errorMessages.add(obj.optString("error", this.context.getString(R.string.nc__error_unknown)));
        } else {
            this.parseErrorsList(errors);
        }
        return errorMessages;
    }

    protected List<String> parseErrorsList(JSONObject errors) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            Iterator i = errors.keys();
            while (i.hasNext()) {
                String title = String.valueOf(i.next());
                String messageTitle = DefaultErrorParser.getBaseErrorTitle(title);
                JSONArray messageArray = errors.optJSONArray(title);
                for (int j = 0; j < messageArray.length(); ++j) {
                    errorMessages.add((messageTitle.length() < 1 ? "" : messageTitle + " ") + messageArray.getString(j) + ".");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorMessages;
    }

    private static String getBaseErrorTitle(String title) {
        if (title.equals("base")) {
            return "";
        }
        String correctTitle = title.replace("_", " ").replace(".", " ");
        return Character.toUpperCase(title.charAt(0)) + correctTitle.substring(1);
    }
}

