/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;

public class TranslateTransitionModule
extends TransitionModule {
    protected float[] translateFrom;
    protected float[] translateTo;
    protected float[] difference;
    protected float[] currentTranslation = new float[2];

    public TranslateTransitionModule(float[] translateFrom, float[] translateTo, long duration) {
        super(duration);
        this.translateFrom = translateFrom;
        this.translateTo = translateTo;
        this.difference = new float[]{translateTo[0] - translateFrom[0], translateTo[1] - translateFrom[1]};
        this.registerInterpolator(0, (Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void onStart(@Nullable Drawable old, Drawable target) {
    }

    @Override
    public void onPredrawOld(TransitionDrawable transitionDrawable, Canvas canvas, @Nullable Drawable old, long startTime) {
    }

    @Override
    public void revertPostDrawOld(TransitionDrawable transitionDrawable, @Nullable Drawable old) {
    }

    @Override
    public void onPredrawTarget(TransitionDrawable transitionDrawable, Canvas canvas, Drawable target, long startTime) {
        if (target instanceof StubDrawable) {
            return;
        }
        float percentCompleted = this.interpolate(0, startTime);
        this.currentTranslation[0] = this.translateFrom[0] + percentCompleted * this.difference[0];
        this.currentTranslation[1] = this.translateFrom[1] + percentCompleted * this.difference[1];
        canvas.translate((float)canvas.getWidth() * this.currentTranslation[0], (float)canvas.getHeight() * this.currentTranslation[1]);
    }

    @Override
    public void revertPostDrawTarget(TransitionDrawable transitionDrawable, Drawable target) {
    }
}

