/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;

public class ScalingTransitionModule
extends TransitionModule {
    protected float scaleFrom;
    protected float scaleTo;
    protected float difference;

    public ScalingTransitionModule(float from, float to, long duration) {
        super(duration);
        this.scaleFrom = from;
        this.scaleTo = to;
        this.difference = to - from;
        this.registerInterpolator(0, (Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void onStart(@Nullable Drawable old, Drawable target) {
    }

    @Override
    public void onPredrawOld(TransitionDrawable transitionDrawable, Canvas canvas, @Nullable Drawable old, long startTime) {
    }

    @Override
    public void revertPostDrawOld(TransitionDrawable transitionDrawable, @Nullable Drawable old) {
    }

    @Override
    public void onPredrawTarget(TransitionDrawable transitionDrawable, Canvas canvas, Drawable target, long startTime) {
        if (target instanceof StubDrawable) {
            return;
        }
        float percentCompleted = this.interpolate(0, startTime);
        float scale = this.scaleFrom + percentCompleted * this.difference;
        canvas.translate(((float)transitionDrawable.getBitmap().getWidth() - scale * (float)transitionDrawable.getBitmap().getWidth()) / 2.0f, ((float)transitionDrawable.getBitmap().getHeight() - scale * (float)transitionDrawable.getBitmap().getHeight()) / 2.0f);
        canvas.scale(scale, scale);
    }

    @Override
    public void revertPostDrawTarget(TransitionDrawable transitionDrawable, Drawable target) {
    }
}

