/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import androidx.annotation.NonNull;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapCenterCropFilter
extends ImageFilter<Bitmap> {
    private int[] desiredBounds;

    public BitmapCenterCropFilter(Context context, @NonNull int[] desiredBounds) {
        super(context);
        this.desiredBounds = desiredBounds;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        float scale = Math.max((float)this.desiredBounds[0] / (float)unedited.getWidth(), (float)this.desiredBounds[1] / (float)unedited.getHeight());
        int xTranslate = (int)(-(scale * (float)unedited.getWidth() - (float)this.desiredBounds[0])) / 2;
        int yTranslate = (int)(-(scale * (float)unedited.getHeight() - (float)this.desiredBounds[1])) / 2;
        Bitmap adjusted = Bitmap.createBitmap((int)this.desiredBounds[0], (int)this.desiredBounds[1], (Bitmap.Config)unedited.getConfig());
        Canvas canvas = new Canvas(adjusted);
        canvas.translate((float)xTranslate, (float)yTranslate);
        canvas.scale(scale, scale);
        canvas.drawBitmap(unedited, 0.0f, 0.0f, null);
        return adjusted;
    }

    @Override
    public String getAdjustmentInfo() {
        return this.getClass().getSimpleName() + "_" + this.desiredBounds[0] + "," + this.desiredBounds[1];
    }
}

