/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import androidx.collection.LruCache;
import com.guardanis.imageloader.R;

public class MemoryCache {
    private static MemoryCache instance;
    protected LruCache<String, BitmapDrawable> cache;

    public static MemoryCache getInstance(Context context) {
        if (instance == null) {
            instance = new MemoryCache(context);
        }
        return instance;
    }

    protected MemoryCache(Context context) {
        int maxAvailableMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int availableMemoryReciprical = context.getResources().getInteger(R.integer.ail__lru_available_memory_reciprical);
        int cacheSize = maxAvailableMemory / availableMemoryReciprical;
        this.cache = new LruCache<String, BitmapDrawable>(cacheSize){

            protected int sizeOf(String key, BitmapDrawable drawable2) {
                return drawable2.getBitmap().getRowBytes() * drawable2.getBitmap().getHeight() / 1024;
            }
        };
    }

    public MemoryCache put(Context context, String key, Bitmap bitmap) {
        this.cache.put((Object)key, (Object)new BitmapDrawable(context.getResources(), bitmap));
        return this;
    }

    public MemoryCache put(String key, BitmapDrawable drawable2) {
        this.cache.put((Object)key, (Object)drawable2);
        return this;
    }

    public BitmapDrawable get(String key) {
        return (BitmapDrawable)this.cache.get((Object)key);
    }
}

