/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.caverock.androidsvg.SVG;
import com.guardanis.imageloader.FileCache;
import com.guardanis.imageloader.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Locale;

public class ImageUtils {
    private static final int MAX_REDUCTION_FACTOR = 16;
    private static final String TAG = "AIL";

    protected ImageUtils() {
    }

    public static void saveStream(File file, InputStream is) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        ImageUtils.copyStream(is, os);
        ((OutputStream)os).close();
    }

    public static void saveBitmapAsync(final Context context, final File imageFile, final Bitmap bitmap) {
        try {
            if (bitmap == null || !ImageUtils.isInternalStorageMounted() && !ImageUtils.safelyCreateImageFile(imageFile)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File temp = new FileCache(context).getFile(System.currentTimeMillis() + "_temp_" + imageFile.getAbsolutePath());
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)new FileOutputStream(temp));
                        temp.renameTo(imageFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isInternalStorageMounted() {
        return Environment.getExternalStorageState().equals("mounted_ro") || Environment.getExternalStorageState().equals("mounted");
    }

    private static boolean safelyCreateImageFile(File imageFile) throws Exception {
        return imageFile.exists() || imageFile.getParentFile().mkdirs() || imageFile.createNewFile();
    }

    public static void copyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Bitmap decodeFile(File file, int requiredWidth) {
        if (file.getName().toLowerCase(Locale.US).endsWith(".svg")) {
            return ImageUtils.decodeSvgFile(file, requiredWidth);
        }
        return ImageUtils.decodeBitmapFile(file, requiredWidth, 1);
    }

    public static Bitmap decodeSVGAsset(Context context, String assetFileName) {
        return ImageUtils.decodeSVGAsset(context, assetFileName, -1);
    }

    public static Bitmap decodeSVGAsset(Context context, String assetFileName, int requiredWidth) {
        try {
            SVG svg = SVG.getFromAsset((AssetManager)context.getAssets(), (String)assetFileName);
            return ImageUtils.decodeBitmap(svg, requiredWidth);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Bitmap decodeSvgFile(File file, int requiredWidth) {
        try {
            return ImageUtils.decodeSvg(new FileInputStream(file), requiredWidth);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeSvgResource(Context context, int resourceId, int requiredWidth) {
        try {
            return ImageUtils.decodeSvg(context.getResources().openRawResource(resourceId), requiredWidth);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap decodeSvg(InputStream stream, int requiredWidth) {
        try {
            Bitmap bitmap = ImageUtils.decodeBitmap(SVG.getFromInputStream((InputStream)stream), requiredWidth);
            stream.close();
            return bitmap;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBitmap(SVG svg, int requiredWidth) {
        float documentWidth = svg.getDocumentWidth();
        float documentHeight = svg.getDocumentHeight();
        if ((documentWidth == -1.0f || documentHeight == -1.0f) && svg.getDocumentViewBox() != null && 0.0f < svg.getDocumentViewBox().width()) {
            documentWidth = svg.getDocumentViewBox().width();
            documentHeight = svg.getDocumentViewBox().height();
        }
        if (documentWidth != -1.0f) {
            if (requiredWidth < 1) {
                requiredWidth = (int)documentWidth;
            }
            float scaleFactor = (float)requiredWidth / documentWidth;
            int adjustedHeight = (int)(scaleFactor * documentHeight);
            Bitmap newBitmap = Bitmap.createBitmap((int)requiredWidth, (int)adjustedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(newBitmap);
            canvas.drawPicture(svg.renderToPicture(), new Rect(0, 0, requiredWidth, adjustedHeight));
            return newBitmap;
        }
        return null;
    }

    private static Bitmap decodeBitmapFile(File file, int requiredWidth, int reductionFactor) {
        try {
            BitmapFactory.Options options = ImageUtils.decodeOptions(new FileInputStream(file));
            return ImageUtils.decodeBitmap(new FileInputStream(file), options, requiredWidth, reductionFactor);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return reductionFactor < 16 ? ImageUtils.decodeBitmapFile(file, requiredWidth, reductionFactor < 1 ? 2 : reductionFactor * 2) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBitmapAsset(Context context, String asset, int requiredWidth) {
        return ImageUtils.decodeBitmapAsset(context, asset, requiredWidth, 1);
    }

    private static Bitmap decodeBitmapAsset(Context context, String asset, int requiredWidth, int reductionFactor) {
        try {
            BitmapFactory.Options options = ImageUtils.decodeOptions(context.getAssets().open(asset));
            return ImageUtils.decodeBitmap(context.getAssets().open(asset), options, requiredWidth, reductionFactor);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return reductionFactor < 16 ? ImageUtils.decodeBitmapAsset(context, asset, requiredWidth, reductionFactor < 1 ? 2 : reductionFactor * 2) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BitmapFactory.Options decodeOptions(InputStream stream) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        stream.close();
        return options;
    }

    private static Bitmap decodeBitmap(InputStream stream, BitmapFactory.Options options, int requiredWidth, int reductionFactor) throws Exception {
        int inSampleSize;
        options.inSampleSize = inSampleSize = ImageUtils.calculateInSampleSize(options, requiredWidth, reductionFactor);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        stream.close();
        return bitmap;
    }

    public static Bitmap decodeDrawableResource(Context context, @DrawableRes int resId, int requiredWidth) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resId);
        if (Build.VERSION.SDK_INT < 21) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
        }
        double drawableAspectRatio = (double)drawable2.getIntrinsicWidth() / (double)drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)requiredWidth, (int)((int)((double)requiredWidth * drawableAspectRatio)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Bitmap decodeBitmapResource(Resources resources, int resId, int requiredWidth) {
        return ImageUtils.decodeBitmapResource(resources, resId, requiredWidth, 1);
    }

    public static Bitmap decodeBitmapResource(Resources resources, int resId, int requiredWidth, int reductionFactor) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
            options.inSampleSize = ImageUtils.calculateInSampleSize(options, requiredWidth, reductionFactor);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.gc();
            return reductionFactor < 16 ? ImageUtils.decodeBitmapResource(resources, resId, requiredWidth, reductionFactor < 1 ? 2 : reductionFactor * 2) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int requiredWidth, int reductionFactor) {
        int inSampleSize = 1;
        if (1 < requiredWidth && requiredWidth < options.outWidth) {
            while (options.outWidth / inSampleSize > requiredWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize * reductionFactor;
    }

    public static StateListDrawable buildStateListDrawable(Context context, SVG svgAssetNormal, SVG svgAssetPressed) {
        return ImageUtils.buildStateListDrawable((Drawable)ImageUtils.buildBitmapDrawable(context, svgAssetNormal), (Drawable)ImageUtils.buildBitmapDrawable(context, svgAssetPressed));
    }

    public static StateListDrawable buildStateListDrawable(Drawable dNormal, Drawable dPressed) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, dPressed);
        states.addState(new int[0], dNormal);
        return states;
    }

    public static BitmapDrawable buildBitmapDrawable(Context context, SVG svg) {
        return new BitmapDrawable(context.getResources(), ImageUtils.decodeBitmap(svg, (int)svg.getDocumentWidth()));
    }

    public static void log(Context context, String message) {
        if (context.getResources().getBoolean(R.bool.ail__debug_log_enabled)) {
            Log.d((String)TAG, (String)message);
        }
    }

    public static void log(Context context, Throwable e) {
        if (context.getResources().getBoolean(R.bool.ail__debug_log_enabled)) {
            e.printStackTrace();
        }
    }

    public static ImageType getImageType(Context context, String url) {
        if ((url = url.toLowerCase(Locale.US)).endsWith(".svg")) {
            return ImageType.SVG;
        }
        if (url.endsWith(".gif")) {
            return ImageType.GIF;
        }
        try {
            Uri uri = Uri.parse((String)URLEncoder.encode(url, "UTF-8"));
            if (uri.getScheme().equals("content") || uri.getScheme().equals("android.resource")) {
                String mimeType = context.getContentResolver().getType(uri);
                return ImageType.valueOf(mimeType.toUpperCase(Locale.US));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageUtils.log(context, String.format("Mime type not found for: %1$s, Treating as a Bitmap", url));
        return ImageType.BITMAP;
    }

    public static enum ImageType {
        BITMAP,
        SVG,
        GIF,
        CUSTOM;

    }
}

