/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.MemoryCache;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.filters.BitmapBlurFilter;
import com.guardanis.imageloader.filters.BitmapCenterCropFilter;
import com.guardanis.imageloader.filters.BitmapCircularCropFilter;
import com.guardanis.imageloader.filters.BitmapColorFilter;
import com.guardanis.imageloader.filters.BitmapColorOverlayFilter;
import com.guardanis.imageloader.filters.BitmapColorOverrideFilter;
import com.guardanis.imageloader.filters.BitmapRotationFilter;
import com.guardanis.imageloader.filters.ImageFilter;
import com.guardanis.imageloader.processors.ExternalImageProcessor;
import com.guardanis.imageloader.processors.ImageAssetProcessor;
import com.guardanis.imageloader.processors.ImageDrawableResourceProcessor;
import com.guardanis.imageloader.processors.ImageFileProcessor;
import com.guardanis.imageloader.processors.ImageProcessor;
import com.guardanis.imageloader.processors.ImageResourceProcessor;
import com.guardanis.imageloader.stubs.builders.StubBuilder;
import com.guardanis.imageloader.transitions.TransitionController;
import com.guardanis.imageloader.transitions.modules.FadingTransitionModule;
import com.guardanis.imageloader.transitions.modules.RotationTransitionModule;
import com.guardanis.imageloader.transitions.modules.ScalingTransitionModule;
import com.guardanis.imageloader.transitions.modules.TransitionModule;
import com.guardanis.imageloader.transitions.modules.TranslateTransitionModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImageRequest<V extends View>
implements Runnable {
    protected static final int DEFAULT_BLUR_RADIUS = 15;
    protected static final int DEFAULT_CROSS_FADE_DURATION = 300;
    protected static final int DEFAULT_SCALE_DURATION = 300;
    protected static final int DEFAULT_ROTATION_DURATION = 300;
    protected static final int WIDTH_UNKNOWN = -1;
    protected Context context;
    protected String targetUrl;
    protected int targetResourceId = -1;
    protected ImageUtils.ImageType targetImageType = ImageUtils.ImageType.BITMAP;
    protected ImageProcessor imageProcessor;
    protected boolean loadingTargetLocally = false;
    protected V targetView;
    protected boolean setImageAsBackground = false;
    protected int requiredImageWidth = -1;
    protected long maxCacheDurationMs = -1L;
    private boolean lruCacheEnabled = true;
    protected List<ImageFilter<Bitmap>> bitmapImageFilters = new ArrayList<ImageFilter<Bitmap>>();
    protected boolean showStubOnExecute = true;
    protected boolean showStubOnError = false;
    protected boolean disableExecutionStubIfDownloaded = true;
    protected StubBuilder loadingStubBuilder;
    protected StubBuilder errorStubBuilder;
    protected TransitionController transitionController = new TransitionController(this);
    protected boolean exitTransitionsEnabled = true;
    protected boolean transitionOnSuccessEnabled = true;
    protected Map<String, String> httpRequestParams = new HashMap<String, String>();
    protected RequestStartedCallback requestStartedCallback;
    protected ImageSuccessCallback successCallback;
    protected boolean triggerSuccessForValidViewsOnly = true;
    protected ImageErrorCallback errorCallback;
    protected boolean tagRequestPreventionEnabled = false;
    protected long startedAtMs;

    public ImageRequest(Context context) {
        this.context = context;
        this.showStubOnExecute = context.getResources().getBoolean(R.bool.ail__show_stub_on_execute);
        this.showStubOnError = context.getResources().getBoolean(R.bool.ail__show_stub_on_error);
        this.lruCacheEnabled = context.getResources().getBoolean(R.bool.ail__lru_cache_enabled);
        this.tagRequestPreventionEnabled = context.getResources().getBoolean(R.bool.ail__tag_request_prevention_enabled);
    }

    public ImageRequest(Context context, V targetView) {
        this(context);
        this.targetView = targetView;
    }

    public ImageRequest<V> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        this.targetImageType = ImageUtils.getImageType(this.context, targetUrl);
        this.loadingTargetLocally = false;
        this.imageProcessor = new ExternalImageProcessor();
        return this;
    }

    public ImageRequest<V> setTargetAsset(String targetAssetUrl) {
        this.targetUrl = targetAssetUrl;
        this.targetImageType = ImageUtils.getImageType(this.context, this.targetUrl);
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageAssetProcessor();
        return this;
    }

    public ImageRequest<V> setTargetFile(String file) {
        return this.setTargetFile(new File(file));
    }

    public ImageRequest<V> setTargetFile(File file) {
        this.targetUrl = file.getAbsolutePath();
        this.targetImageType = ImageUtils.getImageType(this.context, this.targetUrl);
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageFileProcessor();
        return this;
    }

    public ImageRequest<V> setTargetResource(int targetResourceId) {
        return this.setTargetResource(targetResourceId, ImageUtils.ImageType.BITMAP);
    }

    public ImageRequest<V> setTargetResource(int targetResourceId, ImageUtils.ImageType type) {
        this.targetResourceId = targetResourceId;
        this.targetImageType = type;
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageResourceProcessor();
        return this;
    }

    public ImageRequest<V> setTargetDrawable(@DrawableRes int drawableResourceId) {
        this.targetResourceId = drawableResourceId;
        this.targetImageType = ImageUtils.ImageType.CUSTOM;
        this.loadingTargetLocally = true;
        this.showStubOnExecute = this.context.getResources().getBoolean(R.bool.ail__local_execution_stubs);
        this.imageProcessor = new ImageDrawableResourceProcessor();
        return this;
    }

    public ImageRequest<V> overrideImageProcessor(@NonNull ImageProcessor imageProcessor) {
        this.imageProcessor = imageProcessor;
        return this;
    }

    public ImageRequest<V> setTargetView(V targetView) {
        this.targetView = targetView;
        return this;
    }

    public ImageRequest<V> addHttpRequestParam(String key, String value) {
        this.httpRequestParams.put(key, value);
        return this;
    }

    public ImageRequest<V> setRequiredImageWidth(int requiredImageWidth) {
        this.requiredImageWidth = requiredImageWidth;
        return this;
    }

    public ImageRequest<V> setImageAsBackground() {
        this.setImageAsBackground = true;
        return this;
    }

    public ImageRequest<V> setImageAsBackground(boolean setImageAsBackground) {
        this.setImageAsBackground = setImageAsBackground;
        return this;
    }

    public ImageRequest<V> setShowStubOnExecute(boolean showStubOnExecute) {
        this.showStubOnExecute = showStubOnExecute;
        return this;
    }

    public ImageRequest<V> setShowStubOnError(boolean showStubOnError) {
        this.showStubOnError = showStubOnError;
        return this;
    }

    public ImageRequest<V> setDisableExecutionStubIfDownloaded(boolean disableExecutionStubIfDownloaded) {
        this.disableExecutionStubIfDownloaded = disableExecutionStubIfDownloaded;
        return this;
    }

    public ImageRequest<V> setMaxCacheDurationMs(long maxCacheDurationMs) {
        this.maxCacheDurationMs = maxCacheDurationMs;
        return this;
    }

    public ImageRequest<V> setLruCacheEnabled(boolean lruCacheEnabled) {
        this.lruCacheEnabled = lruCacheEnabled;
        return this;
    }

    public ImageRequest<V> setRequestStartedCallback(RequestStartedCallback requestStartedCallback) {
        this.requestStartedCallback = requestStartedCallback;
        return this;
    }

    public ImageRequest<V> setSuccessCallback(ImageSuccessCallback successCallback) {
        this.successCallback = successCallback;
        return this;
    }

    public ImageRequest<V> setTriggerSuccessForValidViewsOnly(boolean triggerSuccessForValidViewsOnly) {
        this.triggerSuccessForValidViewsOnly = triggerSuccessForValidViewsOnly;
        return this;
    }

    public ImageRequest<V> setErrorCallback(ImageErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public ImageRequest<V> addBlurFilter() {
        return this.addBlurFilter(15);
    }

    public ImageRequest<V> addBlurFilter(int blurRadius) {
        return this.addImageFilter(new BitmapBlurFilter(this.context, blurRadius));
    }

    public ImageRequest<V> addColorOverlayFilter(int colorOverlay) {
        return this.addImageFilter(new BitmapColorOverlayFilter(this.context, colorOverlay));
    }

    public ImageRequest<V> addRotationFilter(int rotationDegrees) {
        return this.addImageFilter(new BitmapRotationFilter(this.context, rotationDegrees));
    }

    public ImageRequest<V> addCircularCropFilter() {
        return this.addImageFilter(new BitmapCircularCropFilter(this.context));
    }

    public ImageRequest<V> addColorOverrideFilter(int replacementColor) {
        return this.addImageFilter(new BitmapColorOverrideFilter(this.context, replacementColor));
    }

    public ImageRequest<V> addColorFilter(ColorFilter filter) {
        return this.addImageFilter(new BitmapColorFilter(this.context, filter));
    }

    public ImageRequest<V> addCenterCropFilter(int width, int height) {
        return this.addImageFilter(new BitmapCenterCropFilter(this.context, new int[]{width, height}));
    }

    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        this.bitmapImageFilters.add(imageFilter);
        return this;
    }

    @Deprecated
    public ImageRequest<V> overrideStubs(final StubHolder stubHolder) {
        this.setLoadingStub(new StubBuilder(){

            @Override
            public Drawable build(Context context) {
                return stubHolder.getLoadingDrawable(context);
            }
        });
        this.setErrorStub(new StubBuilder(){

            @Override
            public Drawable build(Context context) {
                return stubHolder.getErrorDrawable(context);
            }
        });
        return this;
    }

    public ImageRequest<V> setLoadingStub(StubBuilder loadingStubBuilder) {
        this.loadingStubBuilder = loadingStubBuilder;
        return this;
    }

    public ImageRequest<V> setErrorStub(StubBuilder errorStubBuilder) {
        this.errorStubBuilder = errorStubBuilder;
        return this;
    }

    public ImageRequest<V> setDefaultImageTransition() {
        this.transitionController.unregisterModules();
        return this;
    }

    public ImageRequest<V> setFadeTransition() {
        return this.setFadeTransition(300L);
    }

    public ImageRequest<V> setFadeTransition(long duration) {
        return this.addImageTransitionModule(new FadingTransitionModule(duration));
    }

    public ImageRequest<V> setScaleTransition(float from, float to) {
        return this.setScaleTransition(from, to, 300L);
    }

    public ImageRequest<V> setScaleTransition(float from, float to, long duration) {
        return this.addImageTransitionModule(new ScalingTransitionModule(from, to, duration));
    }

    public ImageRequest<V> setRotationTransition(int from, int to) {
        return this.setRotationTransition(from, to, 300L);
    }

    public ImageRequest<V> setRotationTransition(int from, int to, long duration) {
        return this.addImageTransitionModule(new RotationTransitionModule(from, to, duration));
    }

    public ImageRequest<V> setTranslateTransition(float fromX, float fromY, long duration) {
        return this.setTranslateTransition(new float[]{fromX, fromY}, new float[]{0.0f, 0.0f}, duration);
    }

    public ImageRequest<V> setTranslateTransition(float fromX, float fromY, float toX, float toY, long duration) {
        return this.setTranslateTransition(new float[]{fromX, fromY}, new float[]{toX, toY}, duration);
    }

    public ImageRequest<V> setTranslateTransition(float[] from, float[] to, long duration) {
        return this.addImageTransitionModule(new TranslateTransitionModule(from, to, duration));
    }

    public ImageRequest<V> addImageTransitionModule(TransitionModule module) {
        this.transitionController.registerModule(module);
        return this;
    }

    public ImageRequest<V> setExitTransitionsEnabled(boolean exitTransitionsEnabled) {
        this.exitTransitionsEnabled = exitTransitionsEnabled;
        return this;
    }

    public ImageRequest<V> setTransitionOnSuccessEnabled(boolean transitionOnSuccessEnabled) {
        this.transitionOnSuccessEnabled = transitionOnSuccessEnabled;
        return this;
    }

    public ImageRequest<V> registerImageTransitionInterpolator(Class c, int interpolatorId, Interpolator interpolator) {
        this.transitionController.registerModuleInterpolator(c, interpolatorId, interpolator);
        return this;
    }

    public ImageRequest<V> setTagRequestPreventionEnabled(boolean tagRequestPreventionEnabled) {
        this.tagRequestPreventionEnabled = tagRequestPreventionEnabled;
        return this;
    }

    @Override
    public void run() {
        boolean processableWithoutView;
        boolean processableWithView = this.targetView != null && ImageLoader.getInstance(this.context).isViewStillUsable(this);
        boolean bl = processableWithoutView = this.targetView == null && 0 < this.getRequiredImageWidth();
        if (!processableWithView && !processableWithoutView) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.requestStartedCallback != null) {
                    ImageRequest.this.requestStartedCallback.onRequestStarted(ImageRequest.this);
                }
            }
        });
        try {
            String cacheKey = this.getEditedRequestFileCacheName();
            BitmapDrawable processed = null;
            if (this.lruCacheEnabled) {
                processed = MemoryCache.getInstance(this.context).get(cacheKey);
            }
            if (processed == null) {
                processed = this.imageProcessor.process(this, this.bitmapImageFilters);
                if (this.lruCacheEnabled && processed != null && processed instanceof BitmapDrawable) {
                    MemoryCache.getInstance(this.context).put(cacheKey, processed);
                }
            }
            this.onRequestCompleted((Drawable)processed);
        }
        catch (Throwable e) {
            ImageUtils.log(this.context, e);
            this.onRequestFailed(e);
        }
    }

    protected int getRequiredImageWidth() {
        if (0 < this.requiredImageWidth) {
            return this.requiredImageWidth;
        }
        return this.targetView != null && this.targetView.getLayoutParams() != null ? this.targetView.getLayoutParams().width : -1;
    }

    protected void onRequestCompleted(final @Nullable Drawable targetDrawable) {
        if (targetDrawable == null) {
            this.onRequestFailed(new RuntimeException("ImageRequest completed with null image!"));
            return;
        }
        if (this.targetView != null) {
            if (ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
                if (this.transitionOnSuccessEnabled) {
                    this.transitionController.transitionTo(targetDrawable);
                }
            } else if (this.triggerSuccessForValidViewsOnly) {
                return;
            }
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ImageRequest.this.successCallback != null) {
                    ImageRequest.this.successCallback.onImageReady(ImageRequest.this, targetDrawable);
                }
            }
        });
    }

    protected void onRequestFailed(Throwable throwable) {
        Throwable error;
        Throwable throwable2 = error = throwable == null ? new RuntimeException("Image could not be loaded") : throwable;
        if (this.targetView != null && ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            this.handleShowStubOnError();
        }
        if (this.targetView == null || ImageLoader.getInstance(this.context).isViewStillUsable(this)) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (ImageRequest.this.errorCallback != null) {
                        ImageRequest.this.errorCallback.onImageLoadingFailure(ImageRequest.this, error);
                    }
                }
            });
        }
    }

    protected void handleShowStubOnError() {
        Drawable targetDrawable = this.showStubOnError ? this.getErrorStubBuilder().build(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_image_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    protected String getEditedRequestFileCacheName() {
        String adjustedName = this.getOriginalRequestFileCacheName();
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            adjustedName = adjustedName + "_" + filter.getAdjustmentInfo();
        }
        return adjustedName + "_" + this.getRequiredImageWidth() + "px";
    }

    public File getEditedRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getEditedRequestFileCacheName());
    }

    protected String getOriginalRequestFileCacheName() {
        return 0 < this.targetResourceId ? String.valueOf(this.targetResourceId) : this.targetUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSetImageAsBackgroundForced() {
        return this.setImageAsBackground;
    }

    public boolean isRequestForBackgroundImage() {
        return this.setImageAsBackground || !(this.targetView instanceof ImageView);
    }

    public V getTargetView() {
        return this.targetView;
    }

    public Map<String, String> getHttpRequestParams() {
        return this.httpRequestParams;
    }

    public long getMaxCacheDurationMs() {
        return this.maxCacheDurationMs;
    }

    public File getOriginalRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getOriginalRequestFileCacheName());
    }

    protected StubBuilder getLoadingStubBuilder() {
        return this.loadingStubBuilder == null ? ImageLoader.getInstance(this.context).getLoadingStubBuilder() : this.loadingStubBuilder;
    }

    protected StubBuilder getErrorStubBuilder() {
        return this.errorStubBuilder == null ? ImageLoader.getInstance(this.context).getErrorStubBuilder() : this.errorStubBuilder;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public int getTargetResourceId() {
        return this.targetResourceId;
    }

    public boolean isExitTransitionEnabled() {
        return this.exitTransitionsEnabled;
    }

    public long getStartedAtMs() {
        return this.startedAtMs;
    }

    public boolean isTargetLocal() {
        return this.loadingTargetLocally;
    }

    public int getTargetImageWidth() {
        return this.getRequiredImageWidth();
    }

    public ImageUtils.ImageType getTargetImageType() {
        return this.targetImageType;
    }

    protected void post(Runnable runnable) {
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).getHandler().post(runnable);
        } else {
            this.targetView.post(runnable);
        }
    }

    protected boolean isTargetDefined() {
        return (this.targetUrl != null && 0 < this.targetUrl.length() || 0 < this.targetResourceId) && this.imageProcessor != null;
    }

    private void handleShowStubOnExecute() {
        if (this.disableExecutionStubIfDownloaded && ImageLoader.getInstance(this.context).isImageDownloaded(this) && ImageLoader.getInstance(this.context).getFileCache().isCachedFileValid(this.targetUrl, this.maxCacheDurationMs)) {
            return;
        }
        Drawable targetDrawable = this.showStubOnExecute ? this.getLoadingStubBuilder().build(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_image_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    public ImageRequest<V> execute() {
        if (!this.isTargetDefined()) {
            this.onRequestFailed(new RuntimeException("No target URL or resource defined!"));
            return this;
        }
        final String fullRequestFile = this.getEditedRequestFileCacheName();
        if (this.isTargetViewClaimedBy(fullRequestFile)) {
            ImageUtils.log(this.context, "View already claimed by duplicate request. Ignoring this one [" + fullRequestFile + "]");
            return this;
        }
        this.startedAtMs = System.currentTimeMillis();
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).submit(this);
        } else {
            ImageLoader.getInstance(this.context).getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (ImageRequest.this.tagRequestPreventionEnabled) {
                        ImageRequest.this.targetView.setTag((Object)fullRequestFile);
                    }
                    ImageLoader.getInstance(ImageRequest.this.context).claimViewTarget(ImageRequest.this);
                    ImageRequest.this.handleShowStubOnExecute();
                    ImageRequest.this.targetView.post(new Runnable(){

                        @Override
                        public void run() {
                            ImageLoader.getInstance(ImageRequest.this.context).submit(ImageRequest.this);
                        }
                    });
                }
            });
        }
        return this;
    }

    protected boolean isTargetViewClaimedBy(String fullRequestFile) {
        return this.tagRequestPreventionEnabled && this.targetView != null && this.targetView.getTag() != null && this.targetView.getTag().equals(fullRequestFile);
    }

    public ImageRequest<V> execute(long delay) {
        ImageLoader.getInstance(this.context).getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ImageRequest.this.execute();
            }
        }, delay);
        return this;
    }

    public static <V extends View> ImageRequest<V> create(@NonNull V targetView) {
        return new ImageRequest<V>(targetView.getContext(), targetView);
    }

    public static ImageRequest prefetch(Context context, String url) {
        return new ImageRequest(context).setTargetUrl(url).execute();
    }

    public static interface ImageErrorCallback {
        public void onImageLoadingFailure(ImageRequest var1, @Nullable Throwable var2);
    }

    public static interface ImageSuccessCallback {
        public void onImageReady(ImageRequest var1, Drawable var2);
    }

    public static interface RequestStartedCallback {
        public void onRequestStarted(ImageRequest var1);
    }
}

