/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.stubs;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.stubs.AnimatedStubDrawable;

public class DefaultLoadingDrawable
extends AnimatedStubDrawable {
    protected static final int MIN_ARC = 5;
    protected static final int MAX_ARC = 360;
    protected static final float ARC_SPEED = 7.25f;
    protected static final float ROTATION_SPEED = 2.85f;
    protected LoadingDrawableState state;
    protected Paint loadingPaint = new Paint();
    protected float rotationDegrees = 0.0f;
    protected float arcAngle = 270.0f;
    protected RectF drawableBounds = new RectF();
    protected boolean arcModeLower = true;
    private int[] lastBounds = new int[]{-1, -1};
    protected int[] sizeRange;

    public DefaultLoadingDrawable(Resources resources) {
        this(resources, resources.getColor(R.color.ail__default_stub_loading_tint));
    }

    public DefaultLoadingDrawable(Resources resources, int color2) {
        this.state = new LoadingDrawableState(resources);
        this.sizeRange = new int[]{(int)resources.getDimension(R.dimen.ail__default_stub_loading_arc_min_size), (int)resources.getDimension(R.dimen.ail__default_stub_loading_arc_max_size)};
        this.setBounds(0, 0, (int)resources.getDimension(R.dimen.ail__default_stub_loading_bounds), (int)resources.getDimension(R.dimen.ail__default_stub_loading_bounds));
        this.setupPaints(resources, color2);
    }

    protected void setupPaints(Resources resources, int color2) {
        this.loadingPaint.setAntiAlias(true);
        this.loadingPaint.setColor(color2);
        this.loadingPaint.setStyle(Paint.Style.STROKE);
        this.loadingPaint.setStrokeWidth(resources.getDimension(R.dimen.ail__default_stub_loading_stroke_width));
    }

    public void draw(Canvas canvas) {
        if (this.lastBounds[0] != canvas.getWidth() || this.lastBounds[1] != canvas.getHeight()) {
            this.setupRect(canvas);
        }
        if (this.canvasMatrixOverride != null) {
            canvas.setMatrix(this.canvasMatrixOverride);
        }
        canvas.save();
        canvas.rotate(this.rotationDegrees, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        canvas.drawArc(this.drawableBounds, 0.0f, this.arcAngle, false, this.loadingPaint);
        canvas.restore();
        canvas.getMatrix(this.baseCanvasMatrix);
        this.updatePositions();
        this.invalidateSelf();
    }

    protected void setupRect(Canvas canvas) {
        int desiredSize = Math.min(canvas.getWidth() / 8, canvas.getHeight() / 5) / 2;
        desiredSize = Math.min(desiredSize, this.sizeRange[1]);
        desiredSize = Math.max(desiredSize, this.sizeRange[0]);
        int[] center = new int[]{canvas.getWidth() / 2, canvas.getHeight() / 2};
        this.drawableBounds.left = center[0] - desiredSize;
        this.drawableBounds.right = center[0] + desiredSize;
        this.drawableBounds.top = center[1] - desiredSize;
        this.drawableBounds.bottom = center[1] + desiredSize;
        this.lastBounds = new int[]{canvas.getWidth(), canvas.getHeight()};
    }

    protected void updatePositions() {
        this.rotationDegrees = (this.rotationDegrees + 2.85f) % 360.0f;
        if (this.arcModeLower) {
            this.arcAngle -= 7.25f;
            if (this.arcAngle <= 5.0f) {
                this.arcModeLower = false;
            }
        } else {
            this.arcAngle += 7.25f;
            if (360.0f <= this.arcAngle) {
                this.arcModeLower = true;
            }
        }
    }

    public int getOpacity() {
        return -2;
    }

    public void setAlpha(int alpha) {
        this.loadingPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter filter) {
        this.loadingPaint.setColorFilter(filter);
    }

    public Drawable.ConstantState getConstantState() {
        this.state.changingConfigurations = super.getChangingConfigurations();
        return this.state;
    }

    static final class LoadingDrawableState
    extends Drawable.ConstantState {
        private Resources resources;
        private int changingConfigurations;

        public LoadingDrawableState(Resources resources) {
            this.resources = resources;
        }

        public Drawable newDrawable() {
            return new DefaultLoadingDrawable(this.resources);
        }

        public Drawable newDrawable(Resources resources) {
            return new DefaultLoadingDrawable(resources);
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }
}

