/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.filters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.guardanis.imageloader.filters.ImageFilter;

public class BitmapCircularCropFilter
extends ImageFilter<Bitmap> {
    private float scale = 1.0f;
    private float[] offsets = new float[]{0.0f, 0.0f};

    public BitmapCircularCropFilter(Context context) {
        super(context);
    }

    public BitmapCircularCropFilter setScaledDimensions(float scale) {
        this.scale = scale;
        return this;
    }

    public BitmapCircularCropFilter setOffsets(float x, float y) {
        this.offsets = new float[]{x, y};
        return this;
    }

    @Override
    public Bitmap filter(Bitmap unedited) {
        Bitmap cropped = Bitmap.createBitmap((int)unedited.getWidth(), (int)unedited.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int xScaled = (int)(this.scale * (float)unedited.getWidth());
        int yScaled = (int)(this.scale * (float)unedited.getHeight());
        int xTranslate = (int)(this.offsets[0] * (float)xScaled) + (unedited.getWidth() - xScaled) / 2;
        int yTranslate = (int)(this.offsets[1] * (float)yScaled) + (unedited.getHeight() - yScaled) / 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Canvas canvas = new Canvas(cropped);
        canvas.clipPath(this.getCircularClippingPath(cropped));
        canvas.drawBitmap(unedited, new Rect(xTranslate, yTranslate, xTranslate + xScaled, yTranslate + yScaled), new Rect(0, 0, unedited.getWidth(), unedited.getHeight()), paint);
        return cropped;
    }

    private Path getCircularClippingPath(Bitmap bitmap) {
        int targetRadius = Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2;
        Path path = new Path();
        path.addCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, (float)targetRadius, Path.Direction.CCW);
        return path;
    }

    @Override
    public String getAdjustmentInfo() {
        return super.getAdjustmentInfo() + "-" + this.scale + "," + this.offsets[0] + "," + this.offsets[1] + "-";
    }
}

